/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LineLineAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;

public class LineEndPointCoveredByLineValidation
extends LineLineAbstractValidation {
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        boolean r = true;
        SimpleFeatureSource fsLine = (SimpleFeatureSource)layers.get(this.getLineTypeRef());
        SimpleFeatureCollection fcLine = fsLine.getFeatures();
        SimpleFeatureIterator fLine = fcLine.features();
        SimpleFeatureSource fsRLine = (SimpleFeatureSource)layers.get(this.getRestrictedLineTypeRef());
        SimpleFeatureCollection fcRLine = fsRLine.getFeatures();
        while (fLine.hasNext()) {
            SimpleFeature line = (SimpleFeature)fLine.next();
            SimpleFeatureIterator fRLine = fcRLine.features();
            Geometry lineGeom = (Geometry)line.getDefaultGeometry();
            if (!envelope.contains(lineGeom.getEnvelopeInternal())) continue;
            if (LineString.class.isAssignableFrom(lineGeom.getClass())) {
                while (fRLine.hasNext()) {
                    SimpleFeature rLine = (SimpleFeature)fRLine.next();
                    Geometry rLineGeom = (Geometry)rLine.getDefaultGeometry();
                    if (envelope.contains(rLineGeom.getEnvelopeInternal())) {
                        if (LineString.class.isAssignableFrom(rLineGeom.getClass())) {
                            Point p1 = ((LineString)rLineGeom).getEndPoint();
                            if (lineGeom.contains((Geometry)p1)) continue;
                            results.error(rLine, "Line End Point not covered by the specified Line.");
                            r = false;
                            continue;
                        }
                        fcRLine.remove(rLine);
                        results.warning(rLine, "Invalid type: this feature is not a derivative of a LineString");
                        continue;
                    }
                    fcRLine.remove(rLine);
                }
                continue;
            }
            results.warning(line, "Invalid type: this feature is not a derivative of a LineString");
        }
        return r;
    }
}

