/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.spatial.LineLineAbstractValidation;
import org.opengis.feature.simple.SimpleFeature;

public class LinesNotIntersectValidation
extends LineLineAbstractValidation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        boolean result = true;
        for (SimpleFeatureSource featureSource : layers.values()) {
            SimpleFeatureIterator features = featureSource.getFeatures().features();
            try {
                while (features.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)features.next();
                    Geometry geom = (Geometry)feature.getDefaultGeometry();
                    for (int i = 0; i < geoms.size(); ++i) {
                        if (!geom.crosses((Geometry)geoms.get(i))) continue;
                        results.error(feature, "Lines cross when they shouldn't.");
                        result = false;
                    }
                    geoms.add(geom);
                }
            }
            finally {
                features.close();
            }
        }
        return result;
    }

    public int getPriority() {
        return 10000;
    }
}

