/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class AdvancedDispatchFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            request = new AdvancedDispatchHttpRequest((HttpServletRequest)request);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    static class AdvancedDispatchHttpRequest
    extends HttpServletRequestWrapper {
        String servletPath = null;

        public AdvancedDispatchHttpRequest(HttpServletRequest delegate) {
            super(delegate);
            if (delegate.getClass().getSimpleName().endsWith("MockHttpServletRequest")) {
                return;
            }
            String path = delegate.getPathInfo();
            int slash = path.indexOf(47, 1);
            this.servletPath = slash > -1 ? path.substring(0, slash) : path;
            int question = this.servletPath.indexOf(63);
            if (question > -1) {
                this.servletPath = this.servletPath.substring(0, question);
            }
        }

        public String getPathInfo() {
            HttpServletRequest delegate = (HttpServletRequest)this.getRequest();
            if (delegate.getPathInfo().startsWith(this.servletPath)) {
                return delegate.getPathInfo().substring(this.servletPath.length());
            }
            return delegate.getPathInfo();
        }

        public String getServletPath() {
            return this.servletPath != null ? this.servletPath : ((HttpServletRequest)this.getRequest()).getServletPath();
        }
    }
}

