/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio;

import it.geosolutions.imageio.stream.input.FileImageInputStreamExtImpl;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverageio.RasterLayerRequest;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

class RasterLayerResponse {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.coverageio");
    private GridCoverage gridCoverage;
    private RasterLayerRequest originatingCoverageRequest;
    private ImageReaderSpi readerSpi;
    private GridCoverageFactory coverageFactory;
    private Hints hints;
    private MathTransform raster2Model;
    private GeneralEnvelope coverageEnvelope;
    private CoordinateReferenceSystem coverageCRS;
    private String coverageName;

    public RasterLayerResponse(RasterLayerRequest request, GridCoverageFactory coverageFactory, ImageReaderSpi readerSpi) {
        this.originatingCoverageRequest = request;
        this.hints = request.getHints();
        this.coverageEnvelope = request.getCoverageEnvelope();
        this.coverageCRS = request.getCoverageCRS();
        this.raster2Model = request.getRaster2Model();
        this.coverageName = request.getCoverageName();
        this.coverageFactory = coverageFactory;
        this.readerSpi = readerSpi;
    }

    public GridCoverage getGridCoverage() {
        return this.gridCoverage;
    }

    public RasterLayerRequest getOriginatingCoverageRequest() {
        return this.originatingCoverageRequest;
    }

    public void compute() throws IOException {
        this.originatingCoverageRequest.prepare();
        if (this.originatingCoverageRequest.isEmptyRequest()) {
            this.gridCoverage = null;
        } else {
            ImageReadParam imageReadParam = this.originatingCoverageRequest.getImageReadParam();
            File input = this.originatingCoverageRequest.getInput();
            boolean useMultithreading = this.originatingCoverageRequest.useMultithreading();
            boolean newTransform = this.originatingCoverageRequest.isAdjustGridToWorldSet();
            boolean useJAI = this.originatingCoverageRequest.useJAI();
            this.gridCoverage = this.createCoverage(input, imageReadParam, useJAI, useMultithreading, newTransform);
        }
    }

    private GridCoverage createCoverage(File input, ImageReadParam imageReadParam, boolean useJAI, boolean useMultithreading, boolean adjustGridToWorld) throws IOException {
        PlanarImage image = this.readRaster(input, useJAI, imageReadParam, useMultithreading);
        if (adjustGridToWorld) {
            int ssWidth = image.getWidth();
            int ssHeight = image.getHeight();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Coverage read: width = " + ssWidth + " height = " + ssHeight);
            }
            Rectangle sourceRegion = imageReadParam.getSourceRegion();
            double scaleX = (double)sourceRegion.width / (1.0 * (double)ssWidth);
            double scaleY = (double)sourceRegion.height / (1.0 * (double)ssHeight);
            double translateX = sourceRegion.x;
            double translateY = sourceRegion.y;
            return this.createCoverageFromImage(image, ConcatenatedTransform.create((MathTransform)ProjectiveTransform.create((AffineTransform)new AffineTransform(scaleX, 0.0, 0.0, scaleY, translateX, translateY)), (MathTransform)this.raster2Model));
        }
        return this.createCoverageFromImage(image);
    }

    protected GridCoverage createCoverageFromImage(PlanarImage image, MathTransform raster2Model) throws IOException {
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        for (int i = 0; i < numBands; ++i) {
            ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation(cm, i);
            if (colorInterpretation == null) {
                throw new IOException("Unrecognized sample dimension type");
            }
            bands[i] = new GridSampleDimension(colorInterpretation.name()).geophysics(true);
        }
        if (raster2Model != null) {
            return this.coverageFactory.create(this.coverageName, (RenderedImage)image, this.coverageCRS, raster2Model, bands, null, null);
        }
        return this.coverageFactory.create((CharSequence)this.coverageName, (RenderedImage)image, (Envelope)new GeneralEnvelope((Envelope)this.coverageEnvelope), bands, null, null);
    }

    protected GridCoverage createCoverageFromImage(PlanarImage image) throws IOException {
        return this.createCoverageFromImage(image, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected PlanarImage readRaster(File input, boolean useJAI, ImageReadParam imageReadParam, boolean useMultithreading) throws IOException {
        PlanarImage raster;
        if (useJAI) {
            ParameterBlock pbjImageRead = new ParameterBlock();
            pbjImageRead.add(new FileImageInputStreamExtImpl(input));
            pbjImageRead.add(0);
            pbjImageRead.add(Boolean.FALSE);
            pbjImageRead.add(Boolean.FALSE);
            pbjImageRead.add(Boolean.FALSE);
            pbjImageRead.add(null);
            pbjImageRead.add(null);
            pbjImageRead.add(imageReadParam);
            pbjImageRead.add(this.readerSpi.createReaderInstance());
            String jaiOperation = useMultithreading ? "ImageReadMT" : "ImageRead";
            return JAI.create((String)jaiOperation, (ParameterBlock)pbjImageRead, (RenderingHints)this.hints);
        }
        ImageReader reader = this.readerSpi.createReaderInstance();
        try {
            reader.setInput(new FileImageInputStreamExtImpl(input), true, true);
            raster = PlanarImage.wrapRenderedImage((RenderedImage)reader.read(0, imageReadParam));
            Object var9_9 = null;
            if (reader == null) return raster;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (reader == null) throw throwable;
            try {
                reader.dispose();
                throw throwable;
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) throw throwable;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            throw throwable;
        }
        try {
            reader.dispose();
            return raster;
        }
        catch (Exception e) {
            if (!LOGGER.isLoggable(Level.FINE)) return raster;
            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
        }
        return raster;
    }
}

