/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.ows.ClientStreamAbortedException;
import org.geoserver.ows.DefaultOutputStrategy;
import org.geoserver.ows.DefaultServiceExceptionHandler;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.DispatcherOutputStream;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.HttpServletRequestAware;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.ows.OutputStrategyFactory;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.ServiceExceptionHandler;
import org.geoserver.ows.ServiceStrategy;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.geotools.xml.EMFUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.SpringSecurityException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserFactory;

public class Dispatcher
extends AbstractController {
    static Logger logger = Logging.getLogger((String)"org.geoserver.ows");
    boolean citeCompliant = false;
    int xmlPostRequestLogBufferSize = 1024;
    public static final ThreadLocal<Request> REQUEST = new InheritableThreadLocal<Request>();
    static final Charset UTF8 = Charset.forName("UTF-8");
    int XML_LOOKAHEAD = 8192;
    List<DispatcherCallback> callbacks = Collections.EMPTY_LIST;

    public void setCiteCompliant(boolean citeCompliant) {
        this.citeCompliant = citeCompliant;
    }

    public boolean isCiteCompliant() {
        return this.citeCompliant;
    }

    protected void initApplicationContext(ApplicationContext context) {
        this.callbacks = GeoServerExtensions.extensions(DispatcherCallback.class, (ApplicationContext)context);
        String lookahead = GeoServerExtensions.getProperty((String)"XML_LOOKAHEAD", (ApplicationContext)context);
        if (lookahead != null) {
            try {
                int lookaheadValue = Integer.valueOf(lookahead);
                if (lookaheadValue <= 0) {
                    logger.log(Level.SEVERE, "Invalid XML_LOOKAHEAD value, will use " + this.XML_LOOKAHEAD + " instead");
                }
                this.XML_LOOKAHEAD = lookaheadValue;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Invalid XML_LOOKAHEAD value, will use " + this.XML_LOOKAHEAD + " instead");
            }
        }
    }

    protected void preprocessRequest(HttpServletRequest request) throws Exception {
        Charset charSet = null;
        charSet = UTF8;
        if (request.getCharacterEncoding() != null) {
            try {
                charSet = Charset.forName(request.getCharacterEncoding());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        request.setCharacterEncoding(charSet.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        this.preprocessRequest(httpRequest);
        Request request = new Request();
        request.setHttpRequest(httpRequest);
        request.setHttpResponse(httpResponse);
        Service service = null;
        try {
            request = this.init(request);
            REQUEST.set(request);
            try {
                service = this.service(request);
            }
            catch (Throwable t) {
                this.exception(t, null, request);
                ModelAndView modelAndView = null;
                this.fireFinishedCallback(request);
                REQUEST.remove();
                return modelAndView;
            }
            if (request.getError() != null) {
                throw request.getError();
            }
            Operation operation = this.dispatch(request, service);
            Object result = this.execute(request, operation);
            if (result != null) {
                this.response(result, request, operation);
            }
        }
        catch (SpringSecurityException e) {
            throw e;
        }
        catch (Throwable t) {
            this.exception(t, service, request);
        }
        finally {
            this.fireFinishedCallback(request);
            REQUEST.remove();
        }
        return null;
    }

    void fireFinishedCallback(Request req) {
        for (DispatcherCallback cb : this.callbacks) {
            cb.finished(req);
        }
    }

    Request init(Request request) throws ServiceException, IOException {
        HttpServletRequest httpRequest = request.getHttpRequest();
        request.setGet("GET".equalsIgnoreCase(httpRequest.getMethod()) || "application/x-www-form-urlencoded".equals(httpRequest.getContentType()));
        this.parseKVP(request);
        if (!request.isGet()) {
            request.setInput(this.reader(httpRequest));
            char[] req = new char[this.xmlPostRequestLogBufferSize];
            int read = request.getInput().read(req, 0, this.xmlPostRequestLogBufferSize);
            if (logger.isLoggable(Level.FINE)) {
                if (read == -1) {
                    request.setInput(null);
                } else if (read < this.xmlPostRequestLogBufferSize) {
                    logger.fine("Raw XML request: " + new String(req));
                } else if (this.xmlPostRequestLogBufferSize != 0) {
                    logger.fine("Raw XML request starts with: " + new String(req) + "...");
                }
            }
            if (read == -1) {
                request.setInput(null);
            } else {
                request.getInput().reset();
            }
        }
        String ctxPath = request.httpRequest.getContextPath();
        String reqPath = request.httpRequest.getRequestURI();
        if ((reqPath = reqPath.substring(ctxPath.length())).startsWith("/")) {
            reqPath = reqPath.substring(1, reqPath.length());
        }
        if (reqPath.endsWith("/")) {
            reqPath = reqPath.substring(0, reqPath.length() - 1);
        }
        String context = reqPath;
        String path = null;
        int index = context.lastIndexOf(47);
        if (index != -1) {
            path = context.substring(index + 1);
            context = context.substring(0, index);
        } else {
            path = reqPath;
            context = null;
        }
        request.setContext(context);
        request.setPath(path);
        return this.fireInitCallback(request);
    }

    Request fireInitCallback(Request req) {
        for (DispatcherCallback cb : this.callbacks) {
            Request r = cb.init(req);
            req = r != null ? r : req;
        }
        return req;
    }

    BufferedReader reader(HttpServletRequest httpRequest) throws IOException {
        return RequestUtils.getBufferedXMLReader((InputStream)httpRequest.getInputStream(), this.XML_LOOKAHEAD);
    }

    Service service(Request req) throws Exception {
        String service;
        if (req.getKvp() != null) {
            req.setService(this.normalize((String)req.getKvp().get("service")));
            req.setVersion(this.normalize((String)req.getKvp().get("version")));
            req.setRequest(this.normalize((String)req.getKvp().get("request")));
            req.setOutputFormat(this.normalize((String)req.getKvp().get("outputFormat")));
        }
        if (req.getInput() != null) {
            Map xml = this.readOpPost(req.getInput());
            if (req.getService() == null) {
                req.setService(this.normalize((String)xml.get("service")));
            }
            if (req.getVersion() == null) {
                req.setVersion(this.normalize((String)xml.get("version")));
            }
            if (req.getRequest() == null) {
                req.setRequest(this.normalize((String)xml.get("request")));
            }
            if (req.getOutputFormat() == null) {
                req.setOutputFormat(this.normalize((String)xml.get("outputFormat")));
            }
        }
        if ((service = req.getService()) == null || req.getRequest() == null) {
            Map map = this.readOpContext(req);
            if (service == null && (service = this.normalize((String)map.get("service"))) != null && !this.citeCompliant) {
                req.setService(service);
            }
            if (req.getRequest() == null) {
                req.setRequest(this.normalize((String)map.get("request")));
            }
        }
        if (service == null) {
            throw new ServiceException("Could not determine service", "MissingParameterValue", "service");
        }
        Service serviceDescriptor = this.findService(service, req.getVersion());
        if (serviceDescriptor == null) {
            if (req.getContext() != null && (serviceDescriptor = this.findService(req.getContext(), req.getVersion())) != null) {
                if (req.getRequest() == null) {
                    req.setRequest(req.getService());
                }
                req.setService(req.getContext());
                req.setContext(null);
            }
            if (serviceDescriptor == null) {
                String msg = "No service: ( " + service + " )";
                throw new ServiceException(msg, "InvalidParameterValue", "service");
            }
        }
        return this.fireServiceDispatchedCallback(req, serviceDescriptor);
    }

    Service fireServiceDispatchedCallback(Request req, Service service) {
        for (DispatcherCallback cb : this.callbacks) {
            Service s = cb.serviceDispatched(req, service);
            service = s != null ? s : service;
        }
        return service;
    }

    String normalize(String value) {
        if (value == null) {
            return null;
        }
        if ("".equals(value.trim())) {
            return null;
        }
        return value.trim();
    }

    Operation dispatch(Request req, Service serviceDescriptor) throws Throwable {
        Object serviceBean;
        Method operation;
        if (req.getRequest() == null) {
            String msg = "Could not determine geoserver request from http request " + req.getHttpRequest();
            throw new ServiceException(msg, "MissingParameterValue", "request");
        }
        boolean exists = false;
        for (String op : serviceDescriptor.getOperations()) {
            if (!op.equalsIgnoreCase(req.getRequest())) continue;
            exists = true;
            break;
        }
        if ((operation = OwsUtils.method((serviceBean = serviceDescriptor.getService()).getClass(), req.getRequest())) == null || !exists) {
            String msg = "No such operation " + req;
            throw new ServiceException(msg, "OperationNotSupported", req.getRequest());
        }
        Object[] parameters = new Object[operation.getParameterTypes().length];
        for (int i = 0; i < parameters.length; ++i) {
            Class<Object> parameterType = operation.getParameterTypes()[i];
            if (parameterType.isAssignableFrom(HttpServletRequest.class)) {
                parameters[i] = req.getHttpRequest();
                continue;
            }
            if (parameterType.isAssignableFrom(HttpServletResponse.class)) {
                parameters[i] = req.getHttpResponse();
                continue;
            }
            if (parameterType.isAssignableFrom(InputStream.class)) {
                parameters[i] = req.getHttpRequest().getInputStream();
                continue;
            }
            if (parameterType.isAssignableFrom(OutputStream.class)) {
                parameters[i] = req.getHttpResponse().getOutputStream();
                continue;
            }
            Object requestBean = null;
            Exception t = null;
            if (req.getKvp() != null && req.getKvp().size() > 0) {
                try {
                    requestBean = this.parseRequestKVP(parameterType, req);
                }
                catch (Exception e) {
                    t = e;
                }
            }
            if (req.getInput() != null) {
                requestBean = this.parseRequestXML(requestBean, req.getInput(), req);
            }
            if (requestBean == null) {
                if (t != null) {
                    throw t;
                }
                throw new ServiceException("Could not find request reader (either kvp or xml) for: " + parameterType.getName());
            }
            Method setBaseUrl = OwsUtils.setter(requestBean.getClass(), "baseUrl", String.class);
            if (setBaseUrl != null) {
                setBaseUrl.invoke(requestBean, (Object[])new String[]{RequestUtils.baseURL(req.getHttpRequest())});
            }
            if (requestBean == null) continue;
            if (req.getService() == null) {
                req.setService(this.lookupRequestBeanProperty(requestBean, "service", false));
            }
            if (req.getVersion() == null) {
                req.setVersion(this.lookupRequestBeanProperty(requestBean, "version", false));
            }
            if (req.getOutputFormat() == null) {
                req.setOutputFormat(this.lookupRequestBeanProperty(requestBean, "outputFormat", true));
            }
            parameters[i] = requestBean;
        }
        if (this.citeCompliant && !"GetCapabilities".equalsIgnoreCase(req.getRequest())) {
            if (req.getVersion() == null) {
                throw new ServiceException("Could not determine version", "MissingParameterValue", "version");
            }
            if (!req.getVersion().matches("[0-99].[0-99].[0-99]")) {
                throw new ServiceException("Invalid version: " + req.getVersion(), "InvalidParameterValue", "version");
            }
            boolean found = false;
            Version version = new Version(req.getVersion());
            for (Service service : this.loadServices()) {
                if (!version.equals((Object)service.getVersion())) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new ServiceException("Invalid version: " + req.getVersion(), "InvalidParameterValue", "version");
            }
            if (req.getService() == null) {
                throw new ServiceException("Could not determine service", "MissingParameterValue", "service");
            }
        }
        Operation op = new Operation(req.getRequest(), serviceDescriptor, operation, parameters);
        return this.fireOperationDispatchedCallback(req, op);
    }

    Operation fireOperationDispatchedCallback(Request req, Operation op) {
        for (DispatcherCallback cb : this.callbacks) {
            Operation o = cb.operationDispatched(req, op);
            op = o != null ? o : op;
        }
        return op;
    }

    String lookupRequestBeanProperty(Object requestBean, String property, boolean allowDefaultValues) {
        if (requestBean instanceof EObject && EMFUtils.has((EObject)((EObject)requestBean), (String)property)) {
            EObject eObject = (EObject)requestBean;
            if (allowDefaultValues || EMFUtils.isSet((EObject)eObject, (String)property)) {
                return this.normalize((String)EMFUtils.get((EObject)eObject, (String)property));
            }
        } else {
            String version = (String)OwsUtils.property(requestBean, property, String.class);
            if (version != null) {
                return this.normalize(version);
            }
        }
        return null;
    }

    Object execute(Request req, Operation opDescriptor) throws Throwable {
        Object result;
        block2: {
            Service serviceDescriptor = opDescriptor.getService();
            Object serviceBean = serviceDescriptor.getService();
            Method operation = opDescriptor.getMethod();
            Object[] parameters = opDescriptor.getParameters();
            result = null;
            try {
                result = operation.invoke(serviceBean, parameters);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() == null) break block2;
                throw e.getTargetException();
            }
        }
        return this.fireOperationExecutedCallback(req, opDescriptor, result);
    }

    Object fireOperationExecutedCallback(Request req, Operation op, Object result) {
        for (DispatcherCallback cb : this.callbacks) {
            Object r = cb.operationExecuted(req, op, result);
            result = r != null ? r : result;
        }
        return result;
    }

    void response(Object result, Request req, Operation opDescriptor) throws Throwable {
        if (result != null) {
            List responses = GeoServerExtensions.extensions(Response.class);
            Iterator itr = responses.iterator();
            block2: while (itr.hasNext()) {
                Response response = (Response)itr.next();
                Class binding = response.getBinding();
                if (!binding.isAssignableFrom(result.getClass()) || !response.canHandle(opDescriptor)) {
                    itr.remove();
                    continue;
                }
                Set<String> outputFormats = response.getOutputFormats();
                if (req.getOutputFormat() == null || outputFormats.isEmpty() || outputFormats.contains(req.getOutputFormat())) continue;
                for (String outputFormat : outputFormats) {
                    if (!req.getOutputFormat().equalsIgnoreCase(outputFormat)) continue;
                    continue block2;
                }
                itr.remove();
            }
            if (responses.isEmpty()) {
                String msg = "No response: ( object = " + result.getClass();
                if (req.getOutputFormat() != null) {
                    msg = msg + ", outputFormat = " + req.getOutputFormat();
                }
                msg = msg + " )";
                throw new RuntimeException(msg);
            }
            if (responses.size() > 1) {
                Collections.sort(responses, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Class c2;
                        Class c1 = ((Response)o1).getBinding();
                        if (c1.equals(c2 = ((Response)o2).getBinding())) {
                            return 0;
                        }
                        if (c1.isAssignableFrom(c2)) {
                            return 1;
                        }
                        if (c2.isAssignableFrom(c1)) {
                            // empty if block
                        }
                        return -1;
                    }
                });
                Response r1 = (Response)responses.get(0);
                Response r2 = (Response)responses.get(1);
                if (r1.getBinding().equals(r2.getBinding())) {
                    String msg = "Multiple responses: (" + result.getClass() + ")";
                    throw new RuntimeException(msg);
                }
            }
            Response response = (Response)responses.get(0);
            response = this.fireResponseDispatchedCallback(req, opDescriptor, result, response);
            ServiceStrategy outputStrategy = this.findOutputStrategy(req.getHttpResponse());
            if (outputStrategy == null) {
                outputStrategy = new DefaultOutputStrategy();
            }
            req.getHttpResponse().setContentType(response.getMimeType(result, opDescriptor));
            if (response.getHeaders(result, opDescriptor) != null) {
                String[][] headers = response.getHeaders(result, opDescriptor);
                for (int i = 0; i < headers.length; ++i) {
                    req.getHttpResponse().addHeader(headers[i][0], headers[i][1]);
                }
            }
            DispatcherOutputStream output = outputStrategy.getDestination(req.getHttpResponse());
            response.write(result, output, opDescriptor);
            try {
                outputStrategy.flush(req.getHttpResponse());
            }
            catch (IOException e) {
                throw new ClientStreamAbortedException(e);
            }
            req.getHttpResponse().getOutputStream().flush();
        }
    }

    Response fireResponseDispatchedCallback(Request req, Operation op, Object result, Response response) {
        for (DispatcherCallback cb : this.callbacks) {
            Response r = cb.responseDispatched(req, op, result, response);
            response = r != null ? r : response;
        }
        return response;
    }

    Collection loadServices() {
        List services = GeoServerExtensions.extensions(Service.class);
        if (new HashSet(services).size() != services.size()) {
            String msg = "Two identical service descriptors found";
            throw new IllegalStateException(msg);
        }
        return services;
    }

    Service findService(String id, String ver) throws ServiceException {
        Version version = ver != null ? new Version(ver) : null;
        Collection services = this.loadServices();
        if (id.contains("/")) {
            id = id.substring(id.indexOf("/") + 1);
        }
        ArrayList<Service> matches = new ArrayList<Service>();
        for (Service sBean : services) {
            if (!sBean.getId().equalsIgnoreCase(id)) continue;
            matches.add(sBean);
        }
        if (matches.isEmpty()) {
            return null;
        }
        Service sBean = null;
        if (matches.size() > 1) {
            ArrayList vmatches = new ArrayList(matches);
            if (version != null) {
                Iterator itr = vmatches.iterator();
                while (itr.hasNext()) {
                    Service s = (Service)itr.next();
                    if (version.equals((Object)s.getVersion())) continue;
                    itr.remove();
                }
                if (vmatches.isEmpty()) {
                    vmatches = new ArrayList(matches);
                }
            }
            if (vmatches.size() > 1) {
                Comparator comparator = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Service s1 = (Service)o1;
                        Service s2 = (Service)o2;
                        return s1.getVersion().compareTo(s2.getVersion());
                    }
                };
                Collections.sort(vmatches, comparator);
            }
            sBean = (Service)vmatches.get(vmatches.size() - 1);
        } else {
            sBean = (Service)matches.get(0);
        }
        return sBean;
    }

    Collection loadKvpRequestReaders() {
        List kvpReaders = GeoServerExtensions.extensions(KvpRequestReader.class);
        if (new HashSet(kvpReaders).size() != kvpReaders.size()) {
            String msg = "Two identical kvp readers found";
            throw new IllegalStateException(msg);
        }
        return kvpReaders;
    }

    KvpRequestReader findKvpRequestReader(Class type) {
        Collection kvpReaders = this.loadKvpRequestReaders();
        ArrayList<KvpRequestReader> matches = new ArrayList<KvpRequestReader>();
        for (KvpRequestReader kvpReader : kvpReaders) {
            if (!kvpReader.getRequestBean().isAssignableFrom(type)) continue;
            matches.add(kvpReader);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            Comparator comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    KvpRequestReader kvp1 = (KvpRequestReader)o1;
                    KvpRequestReader kvp2 = (KvpRequestReader)o2;
                    if (kvp2.getRequestBean().isAssignableFrom(kvp1.getRequestBean())) {
                        return -1;
                    }
                    return 1;
                }
            };
            Collections.sort(matches, comparator);
        }
        return (KvpRequestReader)matches.get(0);
    }

    Collection loadXmlReaders() {
        List xmlReaders = GeoServerExtensions.extensions(XmlRequestReader.class);
        if (new HashSet(xmlReaders).size() != xmlReaders.size()) {
            String msg = "Two identical xml readers found";
            block0: for (int i = 0; i < xmlReaders.size(); ++i) {
                XmlRequestReader r1 = (XmlRequestReader)xmlReaders.get(i);
                for (int j = i + 1; j < xmlReaders.size(); ++j) {
                    XmlRequestReader r2 = (XmlRequestReader)xmlReaders.get(j);
                    if (!r1.equals(r2)) continue;
                    msg = msg + ": " + r1 + " and " + r2;
                    continue block0;
                }
            }
            throw new IllegalStateException(msg);
        }
        return xmlReaders;
    }

    XmlRequestReader findXmlReader(String namespace, String element, String serviceId, String ver) {
        String msg;
        Collection xmlReaders = this.loadXmlReaders();
        ArrayList<XmlRequestReader> matches = new ArrayList<XmlRequestReader>();
        for (XmlRequestReader xmlReader : xmlReaders) {
            QName xmlElement = xmlReader.getElement();
            if (!xmlElement.getLocalPart().equalsIgnoreCase(element) || !xmlElement.getNamespaceURI().equalsIgnoreCase(namespace)) continue;
            matches.add(xmlReader);
        }
        if (matches.isEmpty() && (namespace == null || namespace.equals(""))) {
            msg = "No namespace specified in request, searching for  xml reader by element name only";
            logger.info(msg);
            for (XmlRequestReader xmlReader : xmlReaders) {
                if (!xmlReader.getElement().getLocalPart().equals(element)) continue;
                matches.add(xmlReader);
            }
            if (!matches.isEmpty()) {
                Iterator itr = matches.iterator();
                XmlRequestReader first = (XmlRequestReader)itr.next();
                while (itr.hasNext()) {
                    XmlRequestReader xmlReader = (XmlRequestReader)itr.next();
                    if (first.getElement().equals(xmlReader.getElement())) continue;
                    matches.clear();
                    break;
                }
            }
        }
        if (matches.isEmpty()) {
            msg = "No xml reader: (" + namespace + "," + element + ")";
            logger.info(msg);
            return null;
        }
        XmlRequestReader xmlReader = null;
        if (matches.size() > 1) {
            ArrayList vmatches = new ArrayList(matches);
            if (serviceId != null) {
                Iterator itr = vmatches.iterator();
                while (itr.hasNext()) {
                    XmlRequestReader r = (XmlRequestReader)itr.next();
                    if (r.getServiceId() == null || serviceId.equalsIgnoreCase(r.getServiceId())) continue;
                    itr.remove();
                }
            }
            if (ver != null) {
                Version version = new Version(ver);
                Iterator itr = vmatches.iterator();
                while (itr.hasNext()) {
                    XmlRequestReader r = (XmlRequestReader)itr.next();
                    if (r.getVersion() == null || version.equals((Object)r.getVersion())) continue;
                    itr.remove();
                }
                if (vmatches.isEmpty()) {
                    vmatches = new ArrayList(matches);
                }
            }
            if (vmatches.size() > 1) {
                Comparator comparator = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        XmlRequestReader r1 = (XmlRequestReader)o1;
                        XmlRequestReader r2 = (XmlRequestReader)o2;
                        Version v1 = r1.getVersion();
                        Version v2 = r2.getVersion();
                        if (v1 == null && v2 == null) {
                            return 0;
                        }
                        if (v1 != null && v2 == null) {
                            return 1;
                        }
                        if (v1 == null && v2 != null) {
                            return -1;
                        }
                        int versionCompare = v1.compareTo(v2);
                        if (versionCompare != 0) {
                            return versionCompare;
                        }
                        String sid1 = r1.getServiceId();
                        String sid2 = r2.getServiceId();
                        if (sid1 == null && sid2 == null) {
                            return 0;
                        }
                        if (sid1 != null && sid2 == null) {
                            return 1;
                        }
                        if (sid1 == null && sid2 != null) {
                            return -1;
                        }
                        return sid1.compareTo(sid2);
                    }
                };
                Collections.sort(vmatches, comparator);
            }
            if (vmatches.size() > 0) {
                xmlReader = (XmlRequestReader)vmatches.get(vmatches.size() - 1);
            }
        } else {
            xmlReader = (XmlRequestReader)matches.get(0);
        }
        return xmlReader;
    }

    ServiceStrategy findOutputStrategy(HttpServletResponse response) {
        OutputStrategyFactory factory = null;
        try {
            factory = (OutputStrategyFactory)GeoServerExtensions.bean((String)"serviceStrategyFactory");
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
        return factory.createOutputStrategy(response);
    }

    BufferedInputStream input(File cache) throws IOException {
        return cache == null ? null : new BufferedInputStream(new FileInputStream(cache));
    }

    void preParseKVP(Request req) throws ServiceException {
        HttpServletRequest request = req.getHttpRequest();
        Map kvp = request.getParameterMap();
        if (kvp == null || kvp.isEmpty()) {
            req.setKvp(Collections.EMPTY_MAP);
            return;
        }
        KvpMap parsedKvp = KvpUtils.normalize(kvp);
        KvpMap rawKvp = new KvpMap((Map)parsedKvp);
        req.setKvp(parsedKvp);
        req.setRawKvp(rawKvp);
    }

    void parseKVP(Request req) throws ServiceException {
        this.preParseKVP(req);
        List<Throwable> errors = KvpUtils.parse(req.getKvp());
        if (!errors.isEmpty()) {
            req.setError(errors.get(0));
        }
    }

    Object parseRequestKVP(Class type, Request request) throws Exception {
        KvpRequestReader kvpReader = this.findKvpRequestReader(type);
        if (kvpReader != null) {
            Object requestBean;
            if (kvpReader instanceof HttpServletRequestAware) {
                ((HttpServletRequestAware)((Object)kvpReader)).setHttpRequest(request.getHttpRequest());
            }
            if ((requestBean = kvpReader.createRequest()) != null) {
                requestBean = kvpReader.read(requestBean, request.getKvp(), request.getRawKvp());
            }
            return requestBean;
        }
        return null;
    }

    Object parseRequestXML(Object requestBean, BufferedReader input, Request request) throws Exception {
        if (!input.ready()) {
            return null;
        }
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        XmlPullParser parser = factory.newPullParser();
        parser.setInput((Reader)input);
        parser.nextTag();
        String namespace = parser.getNamespace() != null ? parser.getNamespace() : "";
        String element = parser.getName();
        String version = null;
        String service = null;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if ("version".equals(parser.getAttributeName(i))) {
                version = parser.getAttributeValue(i);
            }
            if (!"service".equals(parser.getAttributeName(i))) continue;
            service = parser.getAttributeValue(i);
        }
        parser.setInput(null);
        input.reset();
        XmlRequestReader xmlReader = this.findXmlReader(namespace, element, service, version);
        if (xmlReader == null) {
            return requestBean;
        }
        if (xmlReader instanceof HttpServletRequestAware) {
            ((HttpServletRequestAware)((Object)xmlReader)).setHttpRequest(request.getHttpRequest());
        }
        return xmlReader.read(requestBean, input, request.getKvp());
    }

    Map readOpContext(Request request) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (request.getPath() != null) {
            map.put("service", request.getPath());
        }
        return map;
    }

    Map readOpPost(BufferedReader input) throws Exception {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        XmlPullParser parser = factory.newPullParser();
        parser.setInput((Reader)input);
        parser.nextTag();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("request", parser.getName());
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attName = parser.getAttributeName(i);
            if ("service".equals(attName)) {
                map.put("service", parser.getAttributeValue(i));
            }
            if ("version".equals(parser.getAttributeName(i))) {
                map.put("version", parser.getAttributeValue(i));
            }
            if (!"outputFormat".equals(attName)) continue;
            map.put("outputFormat", parser.getAttributeValue(i));
        }
        parser.setInput(null);
        input.reset();
        return map;
    }

    void exception(Throwable t, Service service, Request request) {
        Throwable cause;
        Throwable current = t;
        while (current != null && !(current instanceof ClientStreamAbortedException) && !(current instanceof SpringSecurityException)) {
            if (current instanceof SAXException) {
                current = ((SAXException)current).getException();
                continue;
            }
            current = current.getCause();
        }
        if (current instanceof ClientStreamAbortedException) {
            logger.log(Level.FINER, "Client has closed stream", t);
            return;
        }
        if (current instanceof SpringSecurityException) {
            throw (SpringSecurityException)current;
        }
        for (cause = t; !(cause == null || cause instanceof ServiceException || cause instanceof HttpErrorCodeException || cause instanceof SpringSecurityException); cause = cause.getCause()) {
        }
        if (cause == null) {
            cause = new ServiceException(t);
        }
        if (!(cause instanceof HttpErrorCodeException)) {
            logger.log(Level.SEVERE, "", t);
        } else {
            int errorCode = ((HttpErrorCodeException)cause).getErrorCode();
            if (errorCode < 199 || errorCode > 299) {
                logger.log(Level.FINE, "", t);
            } else {
                logger.log(Level.FINER, "", t);
            }
        }
        if (cause instanceof ServiceException) {
            ServiceException se = (ServiceException)cause;
            if (cause != t) {
                se = new ServiceException(se.getMessage(), t, se.getCode(), se.getLocator());
            }
            this.handleServiceException(se, service, request);
        } else if (cause instanceof HttpErrorCodeException) {
            HttpErrorCodeException ece = (HttpErrorCodeException)cause;
            try {
                if (ece.getMessage() != null) {
                    request.getHttpResponse().sendError(ece.getErrorCode(), ece.getMessage());
                } else {
                    request.getHttpResponse().sendError(ece.getErrorCode());
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        request.error = t;
    }

    void handleServiceException(ServiceException se, Service service, Request request) {
        ServiceExceptionHandler handler = null;
        if (service != null) {
            List handlers = GeoServerExtensions.extensions(ServiceExceptionHandler.class);
            for (ServiceExceptionHandler seh : handlers) {
                if (!seh.getServices().contains(service)) continue;
                handler = seh;
                break;
            }
        }
        if (handler == null) {
            handler = new DefaultServiceExceptionHandler();
        }
        ((ServiceExceptionHandler)handler).handleServiceException(se, request);
    }

    public int getXMLPostRequestLogBufferSize() {
        return this.xmlPostRequestLogBufferSize;
    }

    public void setXMLPostRequestLogBufferSize(int bufferSize) {
        this.xmlPostRequestLogBufferSize = bufferSize;
    }
}

