/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.basic;

import org.apache.wicket.extensions.markup.html.basic.ILinkRenderStrategy;
import org.apache.wicket.extensions.markup.html.basic.LinkParser;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class DefaultLinkParser
extends LinkParser {
    private static final String emailPattern = "[\\w\\.-]+@[\\w\\.-]+";
    private static final String urlPattern = "([a-zA-Z]+://[\\w\\.\\-\\:\\/~]+)[\\w\\.:\\-/?&=%]*";
    public static final ILinkRenderStrategy EMAIL_RENDER_STRATEGY = new ILinkRenderStrategy(){

        public String buildLink(String linkTarget) {
            return "<a href=\"mailto:" + linkTarget + "\">" + linkTarget + "</a>";
        }
    };
    public static final ILinkRenderStrategy ENCRYPTED_EMAIL_RENDER_STRATEGY = new ILinkRenderStrategy(){

        public String buildLink(String linkTarget) {
            AppendingStringBuffer cryptedEmail = new AppendingStringBuffer(64);
            for (int i = 0; i < linkTarget.length(); ++i) {
                cryptedEmail.append("&#");
                cryptedEmail.append(Integer.toString(linkTarget.charAt(i)));
                cryptedEmail.append(";");
            }
            AppendingStringBuffer result = new AppendingStringBuffer(256);
            result.append("<a href=\"mailto:");
            result.append(cryptedEmail.toString());
            result.append("\">");
            result.append(cryptedEmail.toString());
            result.append("</a>");
            return result.toString();
        }
    };
    public static final ILinkRenderStrategy URL_RENDER_STRATEGY = new ILinkRenderStrategy(){

        public String buildLink(String linkTarget) {
            return "<a href=\"" + linkTarget + "\">" + (linkTarget.indexOf(63) == -1 ? linkTarget : linkTarget.substring(0, linkTarget.indexOf(63))) + "</a>";
        }
    };

    public DefaultLinkParser() {
        this.addLinkRenderStrategy(emailPattern, EMAIL_RENDER_STRATEGY);
        this.addLinkRenderStrategy(urlPattern, URL_RENDER_STRATEGY);
    }
}

