/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class TileSet
implements Comparable<TileSet> {
    @PrimaryKey
    private String key;
    @SecondaryKey(name="layer", relate=Relationship.MANY_TO_ONE)
    private String layerName;
    private String gridsetId;
    private String blobFormat;
    private Long parametersId;
    private transient int cachedHashCode;

    TileSet() {
    }

    TileSet(String id) {
        this.key = id;
    }

    public TileSet(String layerName, String gridsetId, String blobFormat, Long parametersId) {
        this.layerName = layerName;
        this.gridsetId = gridsetId;
        this.blobFormat = blobFormat;
        this.parametersId = parametersId;
        StringBuilder sb = new StringBuilder(128);
        TileSet.computeId(layerName, gridsetId, blobFormat, parametersId, sb);
        this.key = sb.toString();
    }

    public static void computeId(String layerName, String gridsetId, String blobFormat, Long parametersId, StringBuilder idTarget) {
        idTarget.append(layerName).append('#').append(gridsetId).append('#').append(blobFormat);
        if (parametersId != null) {
            idTarget.append('#').append(parametersId);
        }
    }

    public String getId() {
        return this.key;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public String getGridsetId() {
        return this.gridsetId;
    }

    public String getBlobFormat() {
        return this.blobFormat;
    }

    public Long getParametersId() {
        return this.parametersId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TileSet)) {
            return false;
        }
        TileSet t = (TileSet)o;
        boolean equals = this.key.equals(t.getId());
        return equals;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = 17 * this.key.hashCode();
        }
        return this.cachedHashCode;
    }

    @Override
    public int compareTo(TileSet o) {
        int val = this.layerName.compareTo(o.layerName);
        if (val != 0) {
            return val;
        }
        val = this.gridsetId.compareTo(o.gridsetId);
        if (val != 0) {
            return val;
        }
        val = this.blobFormat.compareTo(o.blobFormat);
        if (val != 0) {
            return val;
        }
        val = this.parametersId == null ? (o.parametersId == null ? 0 : -1) : this.parametersId.intValue() - o.parametersId.intValue();
        return val;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.key + "]";
    }
}

