/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpatialIndexFeatureCollection
implements SimpleFeatureCollection {
    static Logger LOGGER = Logging.getLogger(SpatialIndexFeatureCollection.class);
    protected STRtree index = new STRtree();
    protected SimpleFeatureType schema;
    protected List<CollectionListener> listeners = null;

    @Override
    public synchronized void addListener(CollectionListener listener) throws NullPointerException {
        if (this.listeners == null) {
            this.listeners = Collections.synchronizedList(new ArrayList());
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(CollectionListener listener) throws NullPointerException {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected void fire(SimpleFeature[] features, int eventType) {
        CollectionListener[] notify;
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        CollectionEvent event = new CollectionEvent(this, features, eventType);
        for (CollectionListener listener : notify = this.listeners.toArray(new CollectionListener[this.listeners.size()])) {
            try {
                listener.collectionChanged(event);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Problem encountered during notification of " + event, t);
            }
        }
    }

    @Override
    public SimpleFeatureIterator features() {
        Envelope everything = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        List list = this.index.query(everything);
        final Iterator iterator = list.iterator();
        return new SimpleFeatureIterator(){

            public SimpleFeature next() throws NoSuchElementException {
                return (SimpleFeature)iterator.next();
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public void close() {
            }
        };
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accepts(final FeatureVisitor visitor, ProgressListener listener) throws IOException {
        Envelope everything = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        final ProgressListener progress = listener != null ? listener : new NullProgressListener();
        progress.started();
        final float size = this.size();
        this.index.query(everything, new ItemVisitor(){
            float count = 0.0f;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitItem(Object item) {
                try {
                    SimpleFeature feature = (SimpleFeature)item;
                    visitor.visit((Feature)feature);
                }
                catch (Throwable t) {
                    progress.exceptionOccurred(t);
                }
                finally {
                    progress.progress(this.count / size);
                }
            }
        });
        progress.complete();
    }

    @Override
    public boolean add(SimpleFeature feature) {
        ReferencedEnvelope bounds = ReferencedEnvelope.reference(feature.getBounds());
        this.index.insert(bounds, (Object)feature);
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends SimpleFeature> collection) {
        for (SimpleFeature simpleFeature : collection) {
            try {
                ReferencedEnvelope bounds = ReferencedEnvelope.reference(simpleFeature.getBounds());
                this.index.insert(bounds, (Object)simpleFeature);
            }
            catch (Throwable t) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(FeatureCollection<? extends SimpleFeatureType, ? extends SimpleFeature> collection) {
        FeatureIterator<? extends SimpleFeature> iter = collection.features();
        try {
            while (iter.hasNext()) {
                try {
                    SimpleFeature feature = iter.next();
                    ReferencedEnvelope bounds = ReferencedEnvelope.reference(feature.getBounds());
                    this.index.insert(bounds, (Object)feature);
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            iter.close();
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        this.index = null;
        this.index = new STRtree();
        this.listeners.clear();
        this.listeners = null;
    }

    @Override
    public void close(FeatureIterator<SimpleFeature> close) {
    }

    @Override
    public void close(Iterator<SimpleFeature> close) {
    }

    @Override
    public boolean contains(Object obj) {
        if (obj instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)obj;
            ReferencedEnvelope bounds = ReferencedEnvelope.reference(feature.getBounds());
            Iterator iter = (Iterator)((Object)this.index.query(bounds));
            while (iter.hasNext()) {
                SimpleFeature sample = (SimpleFeature)iter.next();
                if (sample != feature) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        boolean containsAll = true;
        for (Object obj : collection) {
            boolean contains = this.contains(obj);
            if (contains) continue;
            containsAll = false;
            break;
        }
        return containsAll;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        CoordinateReferenceSystem crs = this.schema.getCoordinateReferenceSystem();
        Envelope bounds = (Envelope)this.index.getRoot().getBounds();
        return new ReferencedEnvelope(bounds, crs);
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    @Override
    public boolean isEmpty() {
        return this.index.itemsTree().isEmpty();
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        Envelope everything = new Envelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        List list = this.index.query(everything);
        return list.iterator();
    }

    @Override
    public void purge() {
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot remove items from STRtree");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot remove items from STRtree");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot remove items from STRtree");
    }

    @Override
    public int size() {
        return this.index.size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <O> O[] toArray(O[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        Iterator<SimpleFeature> it = this.iterator();
        try {
            O[] result = array;
            for (int i = 0; i < size; ++i) {
                result[i] = it.next();
            }
            if (array.length > size) {
                array[size] = null;
            }
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            this.close(it);
        }
    }
}

