/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.view;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultView
implements SimpleFeatureSource {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.view");
    protected SimpleFeatureSource source;
    private SimpleFeatureType schema;
    private Query constraintQuery;

    public DefaultView(SimpleFeatureSource source, Query query) throws SchemaException {
        this.source = source;
        this.constraintQuery = query;
        SimpleFeatureType origionalType = (SimpleFeatureType)source.getSchema();
        CoordinateReferenceSystem cs = null;
        if (query.getCoordinateSystemReproject() != null) {
            cs = query.getCoordinateSystemReproject();
        } else if (query.getCoordinateSystem() != null) {
            cs = query.getCoordinateSystem();
        }
        this.schema = DataUtilities.createSubType(origionalType, query.getPropertyNames(), cs, query.getTypeName(), null);
    }

    public Name getName() {
        return this.getSchema().getName();
    }

    public static SimpleFeatureSource create(SimpleFeatureSource source, Query query) throws SchemaException {
        if (source instanceof FeatureLocking || source instanceof FeatureStore) {
            // empty if block
        }
        return new DefaultView(source, query);
    }

    protected DefaultQuery makeDefinitionQuery(Query query) throws IOException {
        if (query == Query.ALL || query.equals(Query.ALL)) {
            return new DefaultQuery(this.constraintQuery);
        }
        try {
            URI namespace;
            String[] propNames = this.extractAllowedAttributes(query);
            String typeName = query.getTypeName();
            if (typeName == null) {
                typeName = this.constraintQuery.getTypeName();
            }
            if ((namespace = query.getNamespace()) == null || namespace == Query.NO_NAMESPACE) {
                namespace = this.constraintQuery.getNamespace();
            }
            Filter filter = this.makeDefinitionFilter(query.getFilter());
            int maxFeatures = Math.min(query.getMaxFeatures(), this.constraintQuery.getMaxFeatures());
            String handle = query.getHandle();
            if (handle == null) {
                handle = this.constraintQuery.getHandle();
            } else if (this.constraintQuery.getHandle() != null) {
                handle = handle + "(" + this.constraintQuery.getHandle() + ")";
            }
            DefaultQuery defaultQuery = new DefaultQuery(typeName, namespace, filter, maxFeatures, propNames, handle);
            defaultQuery.setSortBy(query.getSortBy());
            return defaultQuery;
        }
        catch (Exception ex) {
            throw new DataSourceException("Could not restrict the query to the definition criteria: " + ex.getMessage(), ex);
        }
    }

    private String[] extractAllowedAttributes(Query query) {
        String[] propNames = null;
        if (query.retrieveAllProperties()) {
            propNames = new String[this.schema.getAttributeCount()];
            for (int i = 0; i < this.schema.getAttributeCount(); ++i) {
                propNames[i] = this.schema.getDescriptor(i).getLocalName();
            }
        } else {
            String[] queriedAtts = query.getPropertyNames();
            int queriedAttCount = queriedAtts.length;
            LinkedList<String> allowedAtts = new LinkedList<String>();
            for (int i = 0; i < queriedAttCount; ++i) {
                if (this.schema.getDescriptor(queriedAtts[i]) != null) {
                    allowedAtts.add(queriedAtts[i]);
                    continue;
                }
                LOGGER.info("queried a not allowed property: " + queriedAtts[i] + ". Ommitting it from query");
            }
            propNames = allowedAtts.toArray(new String[allowedAtts.size()]);
        }
        return propNames;
    }

    protected Filter makeDefinitionFilter(Filter filter) throws DataSourceException {
        Filter newFilter = filter;
        Filter constraintFilter = this.constraintQuery.getFilter();
        try {
            if (constraintFilter != Filter.INCLUDE) {
                FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
                newFilter = ff.and(constraintFilter, filter);
            }
        }
        catch (Exception ex) {
            throw new DataSourceException("Can't create the constraint filter", ex);
        }
        return newFilter;
    }

    public DataStore getDataStore() {
        return (DataStore)this.source.getDataStore();
    }

    public void addFeatureListener(FeatureListener listener) {
        this.source.addFeatureListener(listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.source.removeFeatureListener(listener);
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        SimpleFeatureCollection results;
        block12: {
            DefaultQuery mergedQuery = this.makeDefinitionQuery(query);
            results = this.source.getFeatures(mergedQuery);
            CoordinateReferenceSystem cCs = this.constraintQuery.getCoordinateSystem();
            CoordinateReferenceSystem cCsr = this.constraintQuery.getCoordinateSystemReproject();
            CoordinateReferenceSystem qCs = query.getCoordinateSystem();
            CoordinateReferenceSystem qCsr = query.getCoordinateSystemReproject();
            try {
                CoordinateReferenceSystem reprojectCS;
                if (qCsr != null && cCsr != null) {
                    if (cCs != null) {
                        results = new ForceCoordinateSystemFeatureResults(results, cCs);
                    }
                    results = new ReprojectFeatureResults(results, cCsr);
                    if (qCs != null) {
                        results = new ForceCoordinateSystemFeatureResults(results, qCs);
                    }
                    results = new ReprojectFeatureResults(results, qCsr);
                    break block12;
                }
                if (qCs != null && cCsr != null) {
                    try {
                        if (cCs != null) {
                            results = new ForceCoordinateSystemFeatureResults(results, cCs);
                        }
                        results = new ReprojectFeatureResults(this.source.getFeatures(mergedQuery), cCsr);
                        results = new ForceCoordinateSystemFeatureResults(results, qCs);
                        break block12;
                    }
                    catch (SchemaException e) {
                        throw new DataSourceException("This should not happen", e);
                    }
                }
                CoordinateReferenceSystem forcedCS = qCs != null ? qCs : cCs;
                CoordinateReferenceSystem coordinateReferenceSystem = reprojectCS = qCsr != null ? qCsr : cCsr;
                if (forcedCS != null) {
                    results = new ForceCoordinateSystemFeatureResults(results, forcedCS);
                }
                if (reprojectCS != null) {
                    results = new ReprojectFeatureResults(results, reprojectCS);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DataSourceException("A problem occurred while handling forced coordinate systems and reprojection", e);
            }
        }
        return results;
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new DefaultQuery(this.schema.getTypeName(), filter));
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public ResourceInfo getInfo() {
        return new ResourceInfo(){
            final Set<String> words = new HashSet<String>();
            {
                this.words.add("features");
                this.words.add("view");
                this.words.add(DefaultView.this.getSchema().getTypeName());
            }

            @Override
            public ReferencedEnvelope getBounds() {
                try {
                    return DefaultView.this.getBounds();
                }
                catch (IOException e) {
                    return null;
                }
            }

            @Override
            public CoordinateReferenceSystem getCRS() {
                return DefaultView.this.getSchema().getCoordinateReferenceSystem();
            }

            @Override
            public String getDescription() {
                return null;
            }

            @Override
            public Set<String> getKeywords() {
                return this.words;
            }

            @Override
            public String getName() {
                return DefaultView.this.getSchema().getTypeName();
            }

            @Override
            public URI getSchema() {
                Name name = DefaultView.this.getSchema().getName();
                try {
                    URI namespace = new URI(name.getNamespaceURI());
                    return namespace;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            @Override
            public String getTitle() {
                Name name = DefaultView.this.getSchema().getName();
                return name.getLocalPart();
            }
        };
    }

    public ReferencedEnvelope getBounds() throws IOException {
        if (this.constraintQuery.getCoordinateSystemReproject() == null) {
            if (this.constraintQuery.getFilter() == null || this.constraintQuery.getFilter() == Filter.INCLUDE || Filter.INCLUDE.equals(this.constraintQuery.getFilter())) {
                return this.source.getBounds();
            }
            return this.source.getBounds(this.constraintQuery);
        }
        return this.getFeatures().getBounds();
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        if (this.constraintQuery.getCoordinateSystemReproject() == null) {
            try {
                query = this.makeDefinitionQuery(query);
            }
            catch (IOException ex) {
                return null;
            }
            return this.source.getBounds(query);
        }
        return this.getFeatures(query).getBounds();
    }

    public int getCount(Query query) {
        try {
            query = this.makeDefinitionQuery(query);
        }
        catch (IOException ex) {
            return -1;
        }
        try {
            return this.source.getCount(query);
        }
        catch (IOException e) {
            return 0;
        }
    }

    public Set getSupportedHints() {
        return this.source.getSupportedHints();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.source.getQueryCapabilities();
    }
}

