/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.RenderingHints;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.Hints;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.filter.expression.PropertyAccessors;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.xml.sax.helpers.NamespaceSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeExpressionImpl
extends DefaultExpression
implements AttributeExpression {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.core");
    protected String attPath;
    protected SimpleFeatureType schema = null;
    NamespaceSupport namespaceSupport;
    protected boolean lenient = true;
    private Hints hints;
    private PropertyAccessor lastAccessor;

    protected AttributeExpressionImpl(SimpleFeatureType schema) {
        this.schema = schema;
        this.expressionType = (short)113;
    }

    public AttributeExpressionImpl(String xpath) {
        this.attPath = xpath;
        this.schema = null;
        this.namespaceSupport = null;
        this.hints = null;
        this.expressionType = (short)113;
    }

    public AttributeExpressionImpl(Name name) {
        this.attPath = name.getLocalPart();
        this.schema = null;
        if (name.getNamespaceURI() != null) {
            this.namespaceSupport = new NamespaceSupport();
            this.namespaceSupport.declarePrefix("", name.getNamespaceURI());
        } else {
            this.namespaceSupport = null;
        }
        this.expressionType = (short)113;
    }

    public AttributeExpressionImpl(String xpath, NamespaceSupport namespaceContext) {
        this.attPath = xpath;
        this.schema = null;
        this.namespaceSupport = namespaceContext;
        this.expressionType = (short)113;
    }

    public AttributeExpressionImpl(String xpath, Hints hints) {
        this.attPath = xpath;
        this.schema = null;
        this.namespaceSupport = null;
        this.hints = hints;
        this.expressionType = (short)113;
    }

    public NamespaceSupport getNamespaceContext() {
        return this.namespaceSupport;
    }

    protected AttributeExpressionImpl(SimpleFeatureType schema, String attPath) throws IllegalFilterException {
        this.schema = schema;
        this.expressionType = (short)113;
        this.setAttributePath(attPath);
    }

    @Override
    public final void setAttributePath(String attPath) throws IllegalFilterException {
        this.setPropertyName(attPath);
    }

    @Override
    public final String getAttributePath() {
        return this.getPropertyName();
    }

    public String getPropertyName() {
        return this.attPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyName(String attPath) {
        LOGGER.entering("ExpressionAttribute", "setAttributePath", attPath);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("schema: " + this.schema + "\n\nattribute: " + attPath);
        }
        if (this.schema != null) {
            if (this.schema.getDescriptor(attPath) == null) throw new IllegalFilterException("Attribute: " + attPath + " is not in stated schema " + this.schema.getTypeName() + ".");
            this.attPath = attPath;
            return;
        } else {
            this.attPath = attPath;
        }
    }

    @Override
    public Object evaluate(SimpleFeature feature) {
        return this.evaluate(feature, null);
    }

    @Override
    public Object evaluate(Object obj) {
        return this.evaluate(obj, null);
    }

    @Override
    public Object evaluate(Object obj, Class target) {
        PropertyAccessor accessor = this.getLastPropertyAccessor();
        AtomicReference<Object> value = new AtomicReference<Object>();
        AtomicReference<Exception> e = new AtomicReference<Exception>();
        if (accessor == null || !accessor.canHandle(obj, this.attPath, target) || !this.tryAccessor(accessor, obj, target, value, e)) {
            List<PropertyAccessor> accessors;
            boolean success = false;
            if (this.namespaceSupport != null && this.hints == null) {
                this.hints = new Hints((RenderingHints.Key)PropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaceSupport);
            }
            if ((accessors = PropertyAccessors.findPropertyAccessors(obj, this.attPath, target, this.hints)) != null) {
                Iterator<PropertyAccessor> it = accessors.iterator();
                while (!success && it.hasNext()) {
                    accessor = it.next();
                    success = this.tryAccessor(accessor, obj, target, value, e);
                }
            }
            if (!success) {
                if (this.lenient) {
                    return null;
                }
                throw new IllegalArgumentException("Could not find working property accessor for attribute (" + this.attPath + ") in object (" + obj + ")", e.get());
            }
            this.setLastPropertyAccessor(accessor);
        }
        if (target == null) {
            return value.get();
        }
        return Converters.convert(value.get(), target);
    }

    private boolean tryAccessor(PropertyAccessor accessor, Object obj, Class target, AtomicReference<Object> value, AtomicReference<Exception> ex) {
        try {
            value.set(accessor.get(obj, this.attPath, target));
            return true;
        }
        catch (Exception e) {
            ex.set(e);
            return false;
        }
    }

    private synchronized PropertyAccessor getLastPropertyAccessor() {
        return this.lastAccessor;
    }

    private synchronized void setLastPropertyAccessor(PropertyAccessor accessor) {
        this.lastAccessor = accessor;
    }

    public String toString() {
        return this.attPath;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            boolean isEqual;
            AttributeExpressionImpl expAttr = (AttributeExpressionImpl)obj;
            boolean bl = isEqual = expAttr.getType() == this.expressionType;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("expression type match:" + isEqual + "; in:" + expAttr.getType() + "; out:" + this.expressionType);
            }
            boolean bl2 = expAttr.attPath != null ? isEqual && expAttr.attPath.equals(this.attPath) : (isEqual = isEqual && this.attPath == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("attribute match:" + isEqual + "; in:" + expAttr.getAttributePath() + "; out:" + this.attPath);
            }
            boolean bl3 = expAttr.schema != null ? isEqual && expAttr.schema.equals(this.schema) : (isEqual = isEqual && this.schema == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("schema match:" + isEqual + "; in:" + expAttr.schema + "; out:" + this.schema);
            }
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.attPath == null ? 0 : this.attPath.hashCode());
        result = 37 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((PropertyName)this, extraData);
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean isLenient() {
        return this.lenient;
    }
}

