/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecodeFunction
implements Function {
    private static final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private final List<Expression> parameters;
    private final Literal fallback;
    public static final FunctionName NAME = new Name();

    public RecodeFunction() {
        this(new ArrayList<Expression>(), null);
    }

    public RecodeFunction(List<Expression> parameters, Literal fallback) {
        this.parameters = parameters;
        this.fallback = fallback;
    }

    public String getName() {
        return "Recode";
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public Object evaluate(Object object) {
        return this.evaluate(object, Object.class);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        if (this.parameters.size() % 2 != 1) {
            throw new IllegalArgumentException("There must be an equal number of lookup data and return values");
        }
        Expression lookupExp = this.parameters.get(0);
        List<Expression> pairList = this.parameters.subList(1, this.parameters.size());
        for (int i = 0; i < pairList.size(); i += 2) {
            Expression keyExpr = pairList.get(i);
            Expression valueExpr = pairList.get(i + 1);
            PropertyIsEqualTo compareFilter = ff.equal(lookupExp, keyExpr, false);
            if (!compareFilter.evaluate(object)) continue;
            return (T)valueExpr.evaluate(object, context);
        }
        return null;
    }

    public Literal getFallbackValue() {
        return this.fallback;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Name
    implements FunctionName {
        public int getArgumentCount() {
            return -2;
        }

        public List<String> getArgumentNames() {
            return Arrays.asList("LookupValue", "Data 1", "Value 1", "Data 2", "Value 2");
        }

        public String getName() {
            return "Recode";
        }
    }
}

