/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsConverterFactory
implements ConverterFactory {
    private static HashMap<Class<?>, Converter> register = new HashMap();

    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (source == null || !source.equals(String.class)) {
            return null;
        }
        Converter converter = register.get(target);
        if (converter != null) {
            return converter;
        }
        return null;
    }

    static {
        register.put(URI.class, new URIConverter());
        register.put(Number.class, new NumberConverter());
        register.put(Byte.class, new ByteConverter());
        register.put(Byte.TYPE, new ByteConverter());
        register.put(Short.class, new ShortConverter());
        register.put(Short.TYPE, new ShortConverter());
        register.put(Integer.class, new IntegerConverter());
        register.put(Integer.TYPE, new IntegerConverter());
        register.put(Long.class, new LongConverter());
        register.put(Long.TYPE, new LongConverter());
        register.put(BigInteger.class, new BigIntegerConverter());
        register.put(Float.class, new FloatConverter());
        register.put(Float.TYPE, new FloatConverter());
        register.put(Double.class, new DoubleConverter());
        register.put(Double.TYPE, new DoubleConverter());
        register.put(BigDecimalConverter.class, new BigDecimalConverter());
        register.put(Boolean.class, new BooleanConverter());
        register.put(Boolean.TYPE, new BooleanConverter());
        register.put(Character.class, new CharacterConverter());
        register.put(Character.TYPE, new CharacterConverter());
        register.put(File.class, new FileConverter());
        register.put(URL.class, new URLConverter());
        register.put(Date.class, new SQLDateConverter());
        register.put(Time.class, new SQLTimeConverter());
        register.put(Timestamp.class, new SQLTimestampConverter());
        register.put(java.util.Date.class, new DateConverter());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileConverter
    implements Converter {
        FileConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                File parsed = new File(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SQLTimestampConverter
    implements Converter {
        SQLTimestampConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Timestamp parsed = Timestamp.valueOf(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SQLTimeConverter
    implements Converter {
        SQLTimeConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Time parsed = Time.valueOf(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SQLDateConverter
    implements Converter {
        SQLDateConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Date parsed = Date.valueOf(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class URLConverter
    implements Converter {
        URLConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                URL parsed = new URL(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DateConverter
    implements Converter {
        private static SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S a");
        private static SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssa");

        DateConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                java.util.Date parsed = format1.parse(string);
                return target.cast(parsed);
            }
            catch (Exception ignore) {
                try {
                    java.util.Date parsed = format2.parse(string);
                    return target.cast(parsed);
                }
                catch (Exception ignore2) {
                    return null;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CharacterConverter
    implements Converter {
        CharacterConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            if (string.length() > 0) {
                return target.cast(Character.valueOf(string.charAt(0)));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BooleanConverter
    implements Converter {
        BooleanConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("1")) {
                return target.cast(Boolean.TRUE);
            }
            if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("n") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("0")) {
                return target.cast(Boolean.FALSE);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BigDecimalConverter
    implements Converter {
        BigDecimalConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                BigDecimal parsed = new BigDecimal(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DoubleConverter
    implements Converter {
        DoubleConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Double parsed = new Double(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FloatConverter
    implements Converter {
        FloatConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Float parsed = new Float(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BigIntegerConverter
    implements Converter {
        BigIntegerConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                BigInteger parsed = new BigInteger(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LongConverter
    implements Converter {
        LongConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Long parsed = new Long(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntegerConverter
    implements Converter {
        IntegerConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Integer parsed = new Integer(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ShortConverter
    implements Converter {
        ShortConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Short parsed = new Short(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByteConverter
    implements Converter {
        ByteConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                Byte parsed = new Byte(string);
                return target.cast(parsed);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NumberConverter
    implements Converter {
        NumberConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            Number parsed = null;
            try {
                parsed = new IntegerConverter().convert(string, Integer.class);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (parsed == null) {
                parsed = new DoubleConverter().convert(string, Double.class);
            }
            return target.cast(parsed);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class URIConverter
    implements Converter {
        URIConverter() {
        }

        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source == null) {
                return null;
            }
            String string = (String)source;
            try {
                URI uri = new URI(string);
                return target.cast(uri);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
    }
}

