/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.util.time.Duration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxFormValidatingBehavior
extends AjaxFormSubmitBehavior {
    private static final long serialVersionUID = 1L;

    public AjaxFormValidatingBehavior(Form<?> form, String event) {
        super(form, event);
    }

    @Override
    protected void onSubmit(AjaxRequestTarget target) {
        this.addFeedbackPanels(target);
    }

    @Override
    protected void onError(AjaxRequestTarget target) {
        this.addFeedbackPanels(target);
    }

    private void addFeedbackPanels(final AjaxRequestTarget target) {
        this.getComponent().getPage().visitChildren(IFeedback.class, new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                target.addComponent(component);
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        });
    }

    public static void addToAllFormComponents(Form<?> form, String event) {
        AjaxFormValidatingBehavior.addToAllFormComponents(form, event, null);
    }

    public static void addToAllFormComponents(final Form<?> form, final String event, final Duration throttleDelay) {
        form.visitChildren(FormComponent.class, new Component.IVisitor<Component>(){

            @Override
            public Object component(Component component) {
                AjaxFormValidatingBehavior behavior = new AjaxFormValidatingBehavior(form, event);
                if (throttleDelay != null) {
                    behavior.setThrottleDelay(throttleDelay);
                }
                component.add(behavior);
                return Component.IVisitor.CONTINUE_TRAVERSAL_BUT_DONT_GO_DEEPER;
            }
        });
    }
}

