/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image.resource;

import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.IResourceFactory;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.PackageResource;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.parse.metapattern.Group;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.apache.wicket.util.parse.metapattern.OptionalMetaPattern;
import org.apache.wicket.util.parse.metapattern.parsers.MetaPatternParser;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.ValueMap;

public final class LocalizedImageResource
implements IClusterable,
IResourceListener {
    private static final long serialVersionUID = 1L;
    private Boolean resourceKind;
    private final Component component;
    private Resource resource;
    private ResourceReference resourceReference;
    private ValueMap resourceParameters;
    private Locale locale;
    private String style;

    public LocalizedImageResource(Component component) {
        this.component = component;
        this.locale = component.getLocale();
        this.style = component.getStyle();
    }

    public final void bind() {
        if (this.resourceReference != null) {
            this.resourceReference.bind(this.component.getApplication());
            this.resource = this.resourceReference.getResource();
            if (this.resource instanceof PackageResource) {
                this.resourceReference.setLocale(((PackageResource)this.resource).getLocale());
            }
        }
    }

    public final void onResourceRequested() {
        this.bind();
        this.resource.onResourceRequested();
    }

    public final void setResource(Resource resource) {
        if (this.resource != resource) {
            this.resourceKind = Boolean.TRUE;
            this.resource = resource;
        }
    }

    public final void setResourceReference(ResourceReference resourceReference) {
        this.setResourceReference(resourceReference, this.resourceParameters);
    }

    public final boolean isStateless() {
        return this.resourceReference != null;
    }

    public final void setResourceReference(ResourceReference resourceReference, ValueMap resourceParameters) {
        if (resourceReference != this.resourceReference) {
            this.resourceKind = Boolean.FALSE;
            this.resourceReference = resourceReference;
        }
        this.resourceParameters = resourceParameters;
        this.bind();
    }

    public final void setSrcAttribute(ComponentTag tag) {
        Object modelObject;
        Locale l = this.component.getLocale();
        String s = this.component.getStyle();
        if (!(this.resourceKind != null || Objects.equal(this.locale, l) && Objects.equal(this.style, s))) {
            this.locale = l;
            this.style = s;
            this.resourceReference = null;
            this.resource = null;
        }
        if ((modelObject = this.component.getDefaultModelObject()) instanceof ResourceReference) {
            this.resourceReference = (ResourceReference)modelObject;
        } else if (modelObject instanceof Resource) {
            this.resource = (Resource)modelObject;
        }
        if (this.resource == null && this.resourceReference == null) {
            CharSequence src = tag.getString("src");
            if (src != null) {
                this.loadStaticImage(((Object)src).toString());
            } else {
                CharSequence value = tag.getString("value");
                if (value != null) {
                    this.newImage(value);
                } else {
                    this.loadStaticImage(this.component.getDefaultModelObjectAsString());
                }
            }
        }
        CharSequence url = this.resourceReference != null ? RequestCycle.get().urlFor(this.resourceReference, this.resourceParameters) : this.component.urlFor(IResourceListener.INTERFACE);
        tag.put("src", RequestCycle.get().getOriginalResponse().encodeURL(Strings.replaceAll(url, "&", "&amp;")));
    }

    private IResourceFactory getResourceFactory(Application application, String factoryName) {
        IResourceFactory factory = application.getResourceSettings().getResourceFactory(factoryName);
        if (factory == null) {
            throw new WicketRuntimeException("Could not find image resource factory named " + factoryName);
        }
        return factory;
    }

    private void loadStaticImage(String path) {
        MarkupContainer parent = this.component.findParentWithAssociatedMarkup();
        if (parent instanceof Border) {
            parent = parent.getParent();
        }
        Class<?> scope = parent.getClass();
        this.resourceReference = new ResourceReference(scope, path){
            private static final long serialVersionUID = 1L;

            protected Resource newResource() {
                PackageResource pr = PackageResource.get(this.getScope(), this.getName(), LocalizedImageResource.this.locale, LocalizedImageResource.this.style);
                this.locale = pr.getLocale();
                return pr;
            }
        };
        this.resourceReference.setLocale(this.locale);
        this.resourceReference.setStyle(this.style);
        this.bind();
    }

    private void newImage(CharSequence value) {
        ImageValueParser valueParser = new ImageValueParser(value);
        if (valueParser.matches()) {
            String imageReferenceName = valueParser.getImageReferenceName();
            String specification = Strings.replaceHtmlEscapeNumber(valueParser.getSpecification());
            String factoryName = valueParser.getFactoryName();
            Application application = this.component.getApplication();
            if (!Strings.isEmpty(imageReferenceName)) {
                if (application.getSharedResources().get(Application.class, imageReferenceName, this.locale, this.style, true) == null) {
                    Resource imageResource = this.getResourceFactory(application, factoryName).newResource(specification, this.locale, this.style);
                    application.getSharedResources().add(Application.class, imageReferenceName, this.locale, this.style, imageResource);
                }
                this.resourceReference = new ResourceReference(Application.class, imageReferenceName);
                this.resourceReference.setLocale(this.locale);
                this.resourceReference.setStyle(this.style);
            } else {
                this.resource = this.getResourceFactory(application, factoryName).newResource(specification, this.locale, this.style);
            }
        } else {
            throw new WicketRuntimeException("Could not generate image for value attribute '" + value + "'.  Was expecting a value attribute of the form \"[resourceFactoryName]:[resourceReferenceName]?:[factorySpecification]\".");
        }
    }

    public final Resource getResource() {
        return this.resource;
    }

    public final ResourceReference getResourceReference() {
        return this.resourceReference;
    }

    private static final class ImageValueParser
    extends MetaPatternParser {
        private static final Group factoryName = new Group(MetaPattern.VARIABLE_NAME);
        private static final Group imageReferenceName = new Group(MetaPattern.VARIABLE_NAME);
        private static final Group specification = new Group(MetaPattern.ANYTHING_NON_EMPTY);
        private static final MetaPattern pattern = new MetaPattern(new MetaPattern[]{factoryName, MetaPattern.COLON, new OptionalMetaPattern(new MetaPattern[]{imageReferenceName}), MetaPattern.COLON, specification});

        private ImageValueParser(CharSequence input) {
            super(pattern, input);
        }

        private String getFactoryName() {
            return factoryName.get(this.matcher());
        }

        private String getImageReferenceName() {
            return imageReferenceName.get(this.matcher());
        }

        private String getSpecification() {
            return specification.get(this.matcher());
        }
    }
}

