/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.list;

import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.collections.ReadOnlyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Loop
extends AbstractRepeater {
    private static final long serialVersionUID = 1L;

    public Loop(String id, int iterations) {
        super(id, new Model<Integer>(new Integer(iterations)));
    }

    public Loop(String id, IModel<Integer> model) {
        super(id, model);
    }

    public final int getIterations() {
        return (Integer)this.getDefaultModelObject();
    }

    @Override
    protected final void onPopulate() {
        this.removeAll();
        int iterations = this.getIterations();
        if (iterations > 0) {
            for (int iteration = 0; iteration < iterations; ++iteration) {
                LoopItem item = this.newItem(iteration);
                this.add(item);
                this.populateItem(item);
            }
        }
    }

    protected LoopItem newItem(int iteration) {
        return new LoopItem(iteration);
    }

    protected Iterator<Component> renderIterator() {
        final int iterations = this.size();
        return new ReadOnlyIterator<Component>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < iterations;
            }

            @Override
            public Component next() {
                return Loop.this.get(Integer.toString(this.index++));
            }
        };
    }

    protected abstract void populateItem(LoopItem var1);

    @Override
    protected final void renderChild(Component child) {
        this.renderItem((LoopItem)child);
    }

    protected void renderItem(LoopItem item) {
        item.render(this.getMarkupStream());
    }

    public static class LoopItem
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;
        private final int iteration;

        public LoopItem(int iteration) {
            super(Integer.toString(iteration).intern());
            this.iteration = iteration;
        }

        public final int getIteration() {
            return this.iteration;
        }
    }
}

