/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.pagestore;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.http.pagestore.AbstractPageStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerializedPagesCache {
    private final int size;
    private final List<SoftReference<SerializedPageWithSession>> cache;

    public SerializedPagesCache(int size) {
        this.size = size;
        this.cache = new ArrayList<SoftReference<SerializedPageWithSession>>(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SerializedPageWithSession removePage(Page page) {
        if (this.size > 0) {
            List<SoftReference<SerializedPageWithSession>> list = this.cache;
            synchronized (list) {
                Iterator<SoftReference<SerializedPageWithSession>> i = this.cache.iterator();
                while (i.hasNext()) {
                    SoftReference<SerializedPageWithSession> ref = i.next();
                    SerializedPageWithSession entry = ref.get();
                    if (entry == null || entry.page.get() != page) continue;
                    i.remove();
                    return entry;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SerializedPageWithSession getPage(Page page) {
        SerializedPageWithSession result = null;
        if (this.size > 0) {
            List<SoftReference<SerializedPageWithSession>> list = this.cache;
            synchronized (list) {
                Iterator<SoftReference<SerializedPageWithSession>> i = this.cache.iterator();
                while (i.hasNext()) {
                    SoftReference<SerializedPageWithSession> ref = i.next();
                    SerializedPageWithSession entry = ref.get();
                    if (entry == null || entry.page.get() != page) continue;
                    i.remove();
                    result = entry;
                    break;
                }
                if (result != null) {
                    this.cache.add(new SoftReference<Object>(result));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SerializedPageWithSession getPage(String sessionId, int pageId, String pageMapName, int version, int ajaxVersion) {
        if (this.size > 0) {
            List<SoftReference<SerializedPageWithSession>> list = this.cache;
            synchronized (list) {
                for (SoftReference<SerializedPageWithSession> ref : this.cache) {
                    SerializedPageWithSession entry = ref.get();
                    if (entry == null || !entry.sessionId.equals(sessionId) || entry.pageId != pageId || !entry.pageMapName.equals(pageMapName) || entry.versionNumber != version || entry.ajaxVersionNumber != ajaxVersion) continue;
                    return entry;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SerializedPageWithSession storePage(String sessionId, Page page, List<AbstractPageStore.SerializedPage> pagesList) {
        SerializedPageWithSession entry = new SerializedPageWithSession(sessionId, page, pagesList);
        SoftReference<SerializedPageWithSession> ref = new SoftReference<SerializedPageWithSession>(entry);
        if (this.size > 0) {
            List<SoftReference<SerializedPageWithSession>> list = this.cache;
            synchronized (list) {
                this.removePage(page);
                this.cache.add(ref);
                if (this.cache.size() > this.size) {
                    this.cache.remove(0);
                }
            }
        }
        return entry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SerializedPageWithSession
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final transient WeakReference<Object> page;
        final List<AbstractPageStore.SerializedPage> pages;
        final String sessionId;
        final int pageId;
        final String pageMapName;
        final int versionNumber;
        final int ajaxVersionNumber;
        static final Object NO_PAGE = new Object(){};

        SerializedPageWithSession(String sessionId, Page page, List<AbstractPageStore.SerializedPage> pages) {
            this.sessionId = sessionId;
            this.pageId = page.getNumericId();
            this.pageMapName = page.getPageMapName();
            this.versionNumber = page.getCurrentVersionNumber();
            this.ajaxVersionNumber = page.getAjaxVersionNumber();
            this.pages = new ArrayList<AbstractPageStore.SerializedPage>(pages);
            this.page = new WeakReference<Page>(page);
        }

        SerializedPageWithSession(String sessionId, int pageId, String pageMapName, int versionNumber, int ajaxVersionNumber, List<AbstractPageStore.SerializedPage> pages) {
            this.sessionId = sessionId;
            this.page = new WeakReference<Object>(NO_PAGE);
            this.pageId = pageId;
            this.pageMapName = pageMapName;
            this.versionNumber = versionNumber;
            this.ajaxVersionNumber = ajaxVersionNumber;
            this.pages = pages;
        }

        public String toString() {
            return this.getClass().getName() + " [ pageId:" + this.pageId + ", pageMapName: " + this.pageMapName + ", session: " + this.sessionId + "]";
        }
    }
}

