/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.basic;

import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestContext;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.protocol.http.portlet.PortletRequestContext;
import org.apache.wicket.util.string.Strings;

public class RedirectRequestTarget
implements IRequestTarget {
    private final String redirectUrl;

    public RedirectRequestTarget(String redirectUrl) {
        if (Strings.isEmpty(redirectUrl)) {
            throw new IllegalArgumentException("The redirect URL passed to the RedirectRequestTarget constructor can not be null or empty.");
        }
        this.redirectUrl = redirectUrl;
    }

    public void detach(RequestCycle requestCycle) {
    }

    public void respond(RequestCycle requestCycle) {
        Response response = requestCycle.getResponse();
        response.reset();
        if (this.redirectUrl.startsWith("/")) {
            RequestContext rc = RequestContext.get();
            if (rc.isPortletRequest() && ((PortletRequestContext)rc).isEmbedded()) {
                response.redirect(this.redirectUrl);
            } else {
                String location = RequestCycle.get().getProcessor().getRequestCodingStrategy().rewriteStaticRelativeUrl(this.redirectUrl.substring(1));
                if (location.startsWith("./")) {
                    location = location.length() == 2 ? "." : location.substring(2);
                }
                response.redirect(location);
            }
        } else if (this.redirectUrl.contains("://")) {
            response.redirect(this.redirectUrl);
        } else {
            response.redirect(RequestCycle.get().getRequest().getRelativePathPrefixToWicketHandler() + this.redirectUrl);
        }
    }
}

