/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import org.apache.wicket.IRequestTarget;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.AbstractRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.resource.ISharedResourceRequestTarget;
import org.apache.wicket.request.target.resource.SharedResourceRequestTarget;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.value.ValueMap;

public class SharedResourceRequestTargetUrlCodingStrategy
extends AbstractRequestTargetUrlCodingStrategy {
    private final String resourceKey;

    public SharedResourceRequestTargetUrlCodingStrategy(String mountPath, String resourceKey) {
        super(mountPath);
        this.resourceKey = resourceKey;
    }

    public IRequestTarget decode(RequestParameters requestParameters) {
        String parametersFragment = requestParameters.getPath().substring(this.getMountPath().length());
        ValueMap parameters = this.decodeParameters(parametersFragment, requestParameters.getParameters());
        requestParameters.setParameters(parameters);
        requestParameters.setResourceKey(this.resourceKey);
        return new SharedResourceRequestTarget(requestParameters);
    }

    public CharSequence encode(IRequestTarget requestTarget) {
        if (!(requestTarget instanceof ISharedResourceRequestTarget)) {
            throw new IllegalArgumentException("This encoder can only be used with instances of " + ISharedResourceRequestTarget.class.getName());
        }
        AppendingStringBuffer url = new AppendingStringBuffer(40);
        url.append(this.getMountPath());
        ISharedResourceRequestTarget target = (ISharedResourceRequestTarget)requestTarget;
        RequestParameters requestParameters = target.getRequestParameters();
        this.appendParameters(url, requestParameters.getParameters());
        return url;
    }

    public boolean matches(IRequestTarget requestTarget) {
        if (requestTarget instanceof ISharedResourceRequestTarget) {
            ISharedResourceRequestTarget target = (ISharedResourceRequestTarget)requestTarget;
            return target.getRequestParameters().getResourceKey().equals(this.resourceKey);
        }
        return false;
    }

    public String toString() {
        return "SharedResourceEncoder[key=" + this.resourceKey + "]";
    }
}

