/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.loader;

import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.resource.loader.ComponentStringResourceLoader;
import org.apache.wicket.util.resource.locator.ResourceNameIterator;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageStringResourceLoader
extends ComponentStringResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(PackageStringResourceLoader.class);
    private String filename = "package";

    @Override
    public String loadStringResource(Class<?> clazz, String key, Locale locale, String style) {
        if (clazz == null) {
            return null;
        }
        IPropertiesFactory propertiesFactory = Application.get().getResourceSettings().getPropertiesFactory();
        do {
            Package pkg;
            String packageName = (pkg = clazz.getPackage()) == null ? "" : pkg.getName();
            packageName = packageName.replace('.', '/');
            do {
                String path = this.filename;
                if (packageName.length() > 0) {
                    path = packageName + "/" + path;
                }
                ResourceNameIterator iter = new ResourceNameIterator(path, style, locale, null);
                while (iter.hasNext()) {
                    String value;
                    String newPath = iter.next();
                    Properties props = propertiesFactory.load(clazz, newPath);
                    if (props == null || (value = props.getString(key)) == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Found resource from: " + props + "; key: " + key);
                    }
                    return value;
                }
            } while ((packageName = Strings.beforeLast(packageName, '/')).length() > 0);
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

