/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.util.ArrayList;
import java.util.Collection;
import org.geoserver.catalog.LayerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LayerTree {
    private String name;
    private Collection<LayerTree> childrens;
    private Collection<LayerInfo> data;

    public LayerTree(String name) {
        this.name = name;
        this.childrens = new ArrayList<LayerTree>();
        this.data = new ArrayList<LayerInfo>();
    }

    public LayerTree(Collection<LayerInfo> c) {
        this.name = "";
        this.childrens = new ArrayList<LayerTree>();
        this.data = new ArrayList<LayerInfo>();
        for (LayerInfo layer : c) {
            String wmsPath;
            if (!layer.enabled()) continue;
            String string = wmsPath = layer.getPath() == null ? "" : layer.getPath();
            if (wmsPath.startsWith("/")) {
                wmsPath = wmsPath.substring(1, wmsPath.length());
            }
            String[] treeStructure = wmsPath.split("/");
            this.addToNode(this, treeStructure, layer);
        }
    }

    private void addToNode(LayerTree tree, String[] treeStructure, LayerInfo layer) {
        int length = treeStructure.length;
        if (length == 0 || treeStructure[0].length() == 0) {
            tree.data.add(layer);
        } else {
            LayerTree node = tree.getNode(treeStructure[0]);
            if (node == null) {
                node = new LayerTree(treeStructure[0]);
                tree.childrens.add(node);
            }
            String[] subTreeStructure = new String[length - 1];
            System.arraycopy(treeStructure, 1, subTreeStructure, 0, length - 1);
            this.addToNode(node, subTreeStructure, layer);
        }
    }

    public LayerTree getNode(String name) {
        for (LayerTree tmpNode : this.childrens) {
            if (!tmpNode.name.equals(name)) continue;
            return tmpNode;
        }
        return null;
    }

    public Collection<LayerTree> getChildrens() {
        return this.childrens;
    }

    public Collection<LayerInfo> getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }
}

