/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.georss;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.georss.AtomGeoRSSTransformer;
import org.geoserver.wms.georss.GeoRSSTransformerBase;
import org.geoserver.wms.map.XMLTransformerMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomGeoRSSMapOutputFormat
implements GetMapOutputFormat {
    public static String MIME_TYPE = "application/atom+xml";
    public static final Set<String> FORMAT_NAMES;
    private WMS wms;

    public AtomGeoRSSMapOutputFormat(WMS wms) {
        this.wms = wms;
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return FORMAT_NAMES;
    }

    @Override
    public XMLTransformerMap produceMap(WMSMapContext mapContext) throws ServiceException, IOException {
        AtomGeoRSSTransformer tx = new AtomGeoRSSTransformer(this.wms);
        GetMapRequest request = mapContext.getRequest();
        String geometryEncoding = (String)request.getFormatOptions().get("encoding");
        if ("gml".equals(geometryEncoding)) {
            tx.setGeometryEncoding(GeoRSSTransformerBase.GeometryEncoding.GML);
        } else if ("latlong".equals(geometryEncoding)) {
            tx.setGeometryEncoding(GeoRSSTransformerBase.GeometryEncoding.LATLONG);
        } else {
            tx.setGeometryEncoding(GeoRSSTransformerBase.GeometryEncoding.SIMPLE);
        }
        Charset encoding = this.wms.getCharSet();
        tx.setEncoding(encoding);
        XMLTransformerMap result = new XMLTransformerMap(mapContext, tx, (Object)mapContext, this.getMimeType());
        return result;
    }

    static {
        String[] FORMATS = new String[]{MIME_TYPE, "atom", "application/atom xml"};
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        names.addAll(Arrays.asList(FORMATS));
        FORMAT_NAMES = Collections.unmodifiableSet(names);
    }
}

