/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.georss;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.feature.ReprojectingFeatureCollection;
import org.geoserver.wms.WMSMapContext;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.transform.TransformerBase;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class GeoRSSTransformerBase
extends TransformerBase {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.georss");
    static final Configuration GML_CONFIGURATION = new GMLConfiguration();
    protected GeometryEncoding geometryEncoding = GeometryEncoding.LATLONG;

    public void setGeometryEncoding(GeometryEncoding geometryEncoding) {
        this.geometryEncoding = geometryEncoding;
    }

    abstract class GeoRSSTranslatorSupport
    extends TransformerBase.TranslatorSupport
    implements ContentHandler {
        public GeoRSSTranslatorSupport(ContentHandler contentHandler, String prefix, String nsURI) {
            super(contentHandler, prefix, nsURI);
            this.nsSupport.declarePrefix(GeoRSSTransformerBase.this.geometryEncoding.getPrefix(), GeoRSSTransformerBase.this.geometryEncoding.getNamespaceURI());
        }

        protected void encodeGeometry(SimpleFeature feature) {
            if (feature.getDefaultGeometry() != null) {
                GeometryCollection mg;
                Geometry g = (Geometry)feature.getDefaultGeometry();
                if (g instanceof GeometryCollection && (mg = (GeometryCollection)g).getNumGeometries() == 1) {
                    g = mg.getGeometryN(0);
                }
                GeoRSSTransformerBase.this.geometryEncoding.encode(g, this);
            }
        }

        public void start(String element) {
            super.start(element);
        }

        public void element(String element, String content) {
            super.element(element, content);
        }

        protected List loadFeatureCollections(WMSMapContext map) throws IOException {
            ReferencedEnvelope mapArea = map.getAreaOfInterest();
            CoordinateReferenceSystem wgs84 = null;
            FilterFactory ff = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
            try {
                wgs84 = CRS.decode((String)"EPSG:4326");
            }
            catch (Exception e) {
                throw (IOException)new IOException("Unable to decode WGS84...").initCause(e);
            }
            ArrayList<SimpleFeatureCollection> featureCollections = new ArrayList<SimpleFeatureCollection>();
            for (int i = 0; i < map.getLayerCount(); ++i) {
                MapLayer layer = map.getLayer(i);
                Query query = new Query(layer.getQuery());
                SimpleFeatureCollection features = null;
                try {
                    SimpleFeatureSource source = (SimpleFeatureSource)layer.getFeatureSource();
                    GeometryDescriptor gd = ((SimpleFeatureType)source.getSchema()).getGeometryDescriptor();
                    if (gd == null) {
                        features = source.getFeatures(query);
                        continue;
                    }
                    ReferencedEnvelope env = new ReferencedEnvelope(mapArea);
                    CoordinateReferenceSystem sourceCRS = gd.getCoordinateReferenceSystem();
                    if (sourceCRS != null && !CRS.equalsIgnoreMetadata((Object)mapArea.getCoordinateReferenceSystem(), (Object)sourceCRS)) {
                        env = env.transform(sourceCRS, true);
                    }
                    Filter original = query.getFilter();
                    BBOX bbox = ff.bbox(gd.getLocalName(), env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), null);
                    query.setFilter((Filter)ff.and(original, (Filter)bbox));
                    features = source.getFeatures(query);
                    if (sourceCRS != null && !CRS.equalsIgnoreMetadata((Object)wgs84, (Object)sourceCRS)) {
                        ReprojectingFeatureCollection coll = new ReprojectingFeatureCollection(features, wgs84);
                        coll.setDefaultSource(sourceCRS);
                        features = coll;
                    }
                    if (features == null) {
                        throw new NullPointerException();
                    }
                    featureCollections.add(features);
                    continue;
                }
                catch (Exception e) {
                    String msg = "Unable to encode map layer: " + layer;
                    LOGGER.log(Level.SEVERE, msg, e);
                }
            }
            return featureCollections;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String string = new String(ch, start, length);
            this.chars(string);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.end("gml:" + localName);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.start(qName, atts);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (GeoRSSTransformerBase.this.getIndentation() > 0) {
                this.characters(ch, start, length);
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }

    public static class GeometryEncoding {
        public static GeometryEncoding SIMPLE = new GeometryEncoding(){

            public String getPrefix() {
                return "georss";
            }

            public String getNamespaceURI() {
                return "http://www.georss.org/georss";
            }

            public void encode(Geometry g, GeoRSSTranslatorSupport t) {
                Point p;
                if (g instanceof Point) {
                    p = (Point)g;
                    t.element("georss:point", p.getY() + " " + p.getX());
                }
                if (g instanceof LineString) {
                    LineString l = (LineString)g;
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < l.getNumPoints(); ++i) {
                        Coordinate c = l.getCoordinateN(i);
                        sb.append(c.y).append(" ").append(c.x).append(" ");
                    }
                    sb.setLength(sb.length() - 1);
                    t.element("georss:line", sb.toString());
                }
                if (g instanceof Polygon) {
                    p = (Polygon)g;
                    LineString line = p.getExteriorRing();
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < line.getNumPoints(); ++i) {
                        Coordinate c = line.getCoordinateN(i);
                        sb.append(c.y).append(" ").append(c.x).append(" ");
                    }
                    sb.setLength(sb.length() - 1);
                    t.element("georss:polygon", sb.toString());
                }
            }
        };
        public static GeometryEncoding GML = new GeometryEncoding(){

            public String getPrefix() {
                return "gml";
            }

            public String getNamespaceURI() {
                return "http://www.opengis.net/gml";
            }

            public void encode(Geometry g, GeoRSSTranslatorSupport translator) {
                try {
                    QName elementName = null;
                    elementName = g instanceof Point ? org.geotools.gml2.GML.Point : (g instanceof LineString ? org.geotools.gml2.GML.LineString : (g instanceof Polygon ? org.geotools.gml2.GML.Polygon : (g instanceof MultiPoint ? org.geotools.gml2.GML.MultiPoint : (g instanceof MultiLineString ? org.geotools.gml2.GML.MultiLineString : (g instanceof MultiPolygon ? org.geotools.gml2.GML.MultiPolygon : org.geotools.gml2.GML._Geometry)))));
                    Encoder encoder = new Encoder(GML_CONFIGURATION);
                    encoder.encode((Object)g, elementName, (ContentHandler)translator);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot transform the specified geometry in GML", e);
                }
            }
        };
        public static GeometryEncoding LATLONG = new GeometryEncoding(){

            public String getPrefix() {
                return "geo";
            }

            public String getNamespaceURI() {
                return "http://www.w3.org/2003/01/geo/wgs84_pos#";
            }

            public void encode(Geometry g, GeoRSSTranslatorSupport t) {
                Point p = g.getCentroid();
                t.element("geo:lat", "" + p.getY());
                t.element("geo:long", "" + p.getX());
            }
        };

        private GeometryEncoding() {
        }

        public String getPrefix() {
            return null;
        }

        public String getNamespaceURI() {
            return null;
        }

        public void encode(Geometry g, GeoRSSTranslatorSupport translator) {
        }
    }
}

