/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContext;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geotools.image.ImageWorker;
import org.geotools.image.palette.InverseColorMapOp;

public final class GIFMapResponse
extends RenderedImageMapResponse {
    static final String MIME_TYPE = "image/gif";

    public GIFMapResponse(WMS wms) {
        super(MIME_TYPE, wms);
    }

    public void formatImageOutputStream(RenderedImage originalImage, OutputStream outStream, WMSMapContext mapContext) throws ServiceException, IOException {
        InverseColorMapOp paletteInverter = mapContext.getPaletteInverter();
        RenderedImage renderedImage = super.forceIndexed8Bitmask(originalImage, paletteInverter);
        ImageWorker imageWorker = new ImageWorker(renderedImage);
        imageWorker.writeGIF((Object)outStream, "LZW", 0.75f);
    }
}

