/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.validation;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tuckey.web.filters.validation.ServletStreamCollector;

public class ResponseCollector
extends HttpServletResponseWrapper {
    private static Logger log = LoggerFactory.getLogger(ResponseCollector.class);
    private CharArrayWriter writer;
    private boolean checkForDtdDefnDone = false;
    private boolean checkForDtdDefnEnabled = false;
    private ServletStreamCollector os;
    private boolean contentXHTML = false;
    private HttpServletResponse response;

    public ResponseCollector(HttpServletResponse response, boolean checkForDtdDefnEnabled) {
        super(response);
        this.response = response;
        this.writer = new CharArrayWriter(4096);
        this.os = new ServletStreamCollector(this);
        this.checkForDtdDefnEnabled = checkForDtdDefnEnabled;
    }

    public String toString() {
        log.debug("toString Called");
        if (!this.checkForDtdDefnDone && this.checkForDtdDefnEnabled) {
            if (this.writer.size() > 0) {
                if (this.writer.size() > 128) {
                    log.debug("checking output for xhtml header");
                    this.isContentXHTML(this.writer.toString());
                } else {
                    log.debug("content probably not xhtml as not even long enough for dtd defn");
                }
                return this.writer.toString();
            }
            log.debug("os has has itself checked via ServletStreamCollector");
        }
        if (this.writer.size() > 0) {
            return this.writer.toString();
        }
        log.debug("returning os");
        return this.os.toString();
    }

    public PrintWriter getWriter() throws IOException {
        log.debug("getWriter Called");
        return new PrintWriter(this.writer);
    }

    public CharArrayWriter getCharArrayWriter() throws IOException {
        log.debug("getCharArrayWriter Called");
        return this.writer;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        log.debug("getOutputStream Called");
        return this.os;
    }

    public ServletOutputStream getResponseOutputStream() throws IOException {
        log.debug("getResponseOutputStream Called");
        return this.response.getOutputStream();
    }

    public void resetBuffer() {
        log.debug("resetBuffer Called");
    }

    public void flushBuffer() throws IOException {
        log.debug("flushBuffer Called");
    }

    public boolean isContentXHTML() {
        return this.contentXHTML;
    }

    boolean isContentXHTML(String contentSoFar) {
        this.checkForDtdDefnDone = true;
        if (contentSoFar.indexOf("<!DOCTYPE") != -1 && contentSoFar.indexOf("-//W3C//DTD XHTML") != -1) {
            this.contentXHTML = true;
            return true;
        }
        this.contentXHTML = false;
        return false;
    }

    public boolean isCheckForDtdDefnEnabled() {
        return this.checkForDtdDefnEnabled;
    }

    public ServletStreamCollector getServletStreamCollector() {
        return this.os;
    }
}

