/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.validation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tuckey.web.filters.validation.BadXmlParserException;
import org.tuckey.web.filters.validation.LineIssue;
import org.tuckey.web.filters.validation.ValidationDoctype;
import org.tuckey.web.filters.validation.ValidationEntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidationHandler
extends DefaultHandler {
    private static Logger log = LoggerFactory.getLogger(ValidationEntityResolver.class);
    private static final String XHTML_BASIC_IGNORE_ERROR = "A colon is not allowed in the name 'IS10744:arch' when namespaces are enabled";
    private String source;
    private DocumentBuilder parser;
    private final ValidationEntityResolver er;
    private List errors = new ArrayList();
    private final String url;

    public ValidationHandler(String source, String url) throws FileNotFoundException {
        this(source, url, DocumentBuilderFactory.newInstance());
    }

    public ValidationHandler(String source, String url, String xmlParser) throws FileNotFoundException, BadXmlParserException {
        this(source, url, ValidationHandler.getCustomParserInstance(xmlParser));
    }

    private ValidationHandler(String source, String url, DocumentBuilderFactory factory) throws FileNotFoundException {
        this.url = url;
        this.source = source;
        this.er = new ValidationEntityResolver();
        log.debug("setting up parser");
        log.debug("factory: " + factory.getClass().getName());
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        try {
            this.parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error("unable to setup parser", (Throwable)e);
            return;
        }
        log.debug("parser: " + this.parser.getClass().getName());
        this.parser.setErrorHandler(this);
        this.parser.setEntityResolver(this.er);
    }

    public void parse() throws IOException {
        if (this.parser == null) {
            return;
        }
        log.debug("parsing");
        try {
            InputSource inputSource = new InputSource(new StringReader(this.source));
            this.parser.parse(inputSource);
        }
        catch (SAXParseException spe) {
            this.addError(new LineIssue("fat", spe));
        }
        catch (SAXException se) {
            if (se.getException() != null) {
                se.getException().printStackTrace(System.err);
            }
            se.printStackTrace(System.err);
        }
    }

    public void warning(SAXParseException ex) {
        this.addError(new LineIssue("war", ex));
    }

    public void error(SAXParseException ex) {
        this.addError(new LineIssue("err", ex));
        log.debug("error: " + ex.getMessage());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.addError(new LineIssue("fat", ex));
    }

    public boolean isValid() {
        return this.errors.isEmpty();
    }

    private void addError(LineIssue lineIssue) {
        if (this.errors.contains(lineIssue)) {
            return;
        }
        if (this.isFalseError(lineIssue)) {
            return;
        }
        for (int i = 0; i < this.errors.size(); ++i) {
            LineIssue issue = (LineIssue)this.errors.get(i);
            if (!issue.equals(lineIssue)) continue;
            return;
        }
        String msg = lineIssue.getMessage();
        if (msg != null && msg.startsWith("Using original entity definition for") && "war".equals(lineIssue.getType())) {
            log.debug("this warning comes from crimson and it's not important: " + lineIssue.getMessage());
            return;
        }
        this.errors.add(lineIssue);
    }

    protected boolean isFalseError(LineIssue lineIssue) {
        if (lineIssue == null) {
            return false;
        }
        String message = lineIssue.getMessage();
        if (message == null) {
            return false;
        }
        return message.indexOf(XHTML_BASIC_IGNORE_ERROR) != -1;
    }

    public final List getErrors() {
        return this.errors;
    }

    public String[] getSourceAsArrayOfLines() {
        return this.source.split("\n");
    }

    public ValidationDoctype getDoctype() {
        return this.er.getDoctype();
    }

    public DocumentBuilder getParser() {
        return this.parser;
    }

    public static DocumentBuilderFactory getCustomParserInstance(String xmlParser) throws BadXmlParserException {
        DocumentBuilderFactory factory;
        try {
            Class<?> c = Class.forName(xmlParser);
            Object o = c.newInstance();
            factory = (DocumentBuilderFactory)o;
        }
        catch (ClassNotFoundException e) {
            throw new BadXmlParserException(e);
        }
        catch (IllegalAccessException e) {
            throw new BadXmlParserException(e);
        }
        catch (InstantiationException e) {
            throw new BadXmlParserException(e);
        }
        return factory;
    }
}

