/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.NumberValidator;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.web.publish.LayerConfigurationPanel;
import org.geoserver.web.util.MapModel;
import org.opengis.feature.type.PropertyDescriptor;

public class KMLLayerConfigPanel
extends LayerConfigurationPanel {
    static final List<String> KML_STRATEGIES = Arrays.asList("external-sorting", "geometry", "native-sorting", "random");

    public KMLLayerConfigPanel(String id, IModel model) {
        super(id, model);
        PropertyModel metadata = new PropertyModel((Object)model, "resource.metadata");
        this.add(new Component[]{new DropDownChoice("kml.regionateAttribute", (IModel)new MapModel((IModel)metadata, "kml.regionateAttribute"), (IModel)new AttributeNamesModel((IModel)new PropertyModel((Object)model, "resource")))});
        this.add(new Component[]{new DropDownChoice("kml.regionateStrategy", (IModel)new MapModel((IModel)metadata, "kml.regionateStrategy"), KML_STRATEGIES)});
        TextField maxFeatures = new TextField("kml.regionateFeatureLimit", (IModel)new MapModel((IModel)metadata, "kml.regionateFeatureLimit"), Integer.class);
        maxFeatures.add((IValidator)NumberValidator.minimum((long)1L));
        this.add(new Component[]{maxFeatures});
    }

    private static class AttributeNamesModel
    extends LoadableDetachableModel {
        IModel featureTypeInfo;

        public AttributeNamesModel(IModel featureTypeInfo) {
            this.featureTypeInfo = featureTypeInfo;
        }

        protected Object load() {
            try {
                FeatureTypeInfo fti = (FeatureTypeInfo)this.featureTypeInfo.getObject();
                ArrayList<String> result = new ArrayList<String>();
                for (PropertyDescriptor property : fti.getFeatureType().getDescriptors()) {
                    result.add(property.getName().getLocalPart());
                }
                Collections.sort(result);
                return result;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load feature type attribute list", e);
            }
        }
    }
}

