/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.rest;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.rest.CatalogFreemarkerHTMLFormat;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.PageInfo;
import org.geoserver.rest.ReflectiveResource;
import org.geoserver.rest.format.DataFormat;
import org.geoserver.rest.format.MediaTypes;
import org.geoserver.rest.format.ReflectiveXMLFormat;
import org.geotools.util.logging.Logging;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Resource;

public abstract class CatalogResourceBase
extends ReflectiveResource {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog.rest");
    protected Catalog catalog;
    protected Class clazz;
    protected XStreamPersisterFactory xpf;

    public CatalogResourceBase(Context context, Request request, Response response, Class clazz, Catalog catalog) {
        super(context, request, response);
        this.clazz = clazz;
        this.catalog = catalog;
        this.xpf = (XStreamPersisterFactory)GeoServerExtensions.bean(XStreamPersisterFactory.class);
    }

    protected DataFormat createHTMLFormat(Request request, Response response) {
        return new CatalogFreemarkerHTMLFormat(this.clazz, request, response, (Resource)this);
    }

    protected void encodeAlternateAtomLink(String link, HierarchicalStreamWriter writer) {
        this.encodeAlternateAtomLink(link, writer, this.getFormatGet());
    }

    protected void encodeAlternateAtomLink(String link, HierarchicalStreamWriter writer, DataFormat format) {
        writer.startNode("atom:link");
        writer.addAttribute("xmlns:atom", "http://www.w3.org/2005/Atom");
        writer.addAttribute("rel", "alternate");
        writer.addAttribute("href", this.href(link, format));
        if (format != null) {
            writer.addAttribute("type", format.getMediaType().toString());
        }
        writer.endNode();
    }

    protected void encodeLink(String link, HierarchicalStreamWriter writer) {
        this.encodeLink(link, writer, this.getFormatGet());
    }

    protected void encodeLink(String link, HierarchicalStreamWriter writer, DataFormat format) {
        if (this.getFormatGet() instanceof ReflectiveXMLFormat) {
            this.encodeAlternateAtomLink(link, writer, format);
        } else {
            writer.startNode("href");
            writer.setValue(this.href(link, format));
            writer.endNode();
        }
    }

    protected void encodeCollectionLink(String link, HierarchicalStreamWriter writer) {
        this.encodeCollectionLink(link, writer, this.getFormatGet());
    }

    protected void encodeCollectionLink(String link, HierarchicalStreamWriter writer, DataFormat format) {
        if (format instanceof ReflectiveXMLFormat) {
            this.encodeAlternateAtomLink(link, writer, format);
        } else {
            writer.setValue(this.href(link, format));
        }
    }

    String href(String link, DataFormat format) {
        PageInfo pg = this.getPageInfo();
        String ext = null;
        if (format != null) {
            ext = MediaTypes.getExtensionForMediaType((MediaType)format.getMediaType());
        }
        if (ext == null) {
            ext = pg.getExtension();
        }
        if (ext != null && ext.length() > 0) {
            link = link + "." + ext;
        }
        if (link.startsWith("/")) {
            return pg.rootURI(link);
        }
        return pg.pageURI(link);
    }
}

