/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.wfs.v1_0_0.Action;
import org.geotools.data.wfs.v1_0_0.WFSFeatureSource;
import org.geotools.data.wfs.v1_0_0.WFSTransactionState;
import org.geotools.data.wfs.v1_0_0.WFS_1_0_0_DataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.LenientBuilder;
import org.geotools.feature.LenientFeatureFactory;
import org.geotools.feature.NameImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WFSFeatureStore
extends WFSFeatureSource
implements SimpleFeatureStore {
    protected Transaction trans = Transaction.AUTO_COMMIT;

    public WFSFeatureStore(WFS_1_0_0_DataStore ds, String typeName) {
        super(ds, typeName);
    }

    @Override
    public Transaction getTransaction() {
        return this.trans;
    }

    @Override
    public List<FeatureId> addFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        while (reader.hasNext()) {
            try {
                SimpleFeature next = reader.next();
                features.add(next);
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        }
        return this.addFeatures(DataUtilities.collection((SimpleFeature[])features.toArray(new SimpleFeature[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        WFSTransactionState ts = null;
        ts = this.trans == Transaction.AUTO_COMMIT ? new WFSTransactionState(this.ds) : (WFSTransactionState)this.trans.getState(this.ds);
        LinkedList<FeatureId> r = new LinkedList<FeatureId>();
        SimpleFeatureType schema = this.getSchema();
        LenientBuilder build = new LenientBuilder(schema);
        boolean isLenient = true;
        if (schema.getUserData().containsKey("lenient")) {
            isLenient = (Boolean)schema.getUserData().get("lenient");
        }
        if (isLenient) {
            build.setFeatureFactory((FeatureFactory)new LenientFeatureFactory());
        }
        List atrs = schema.getAttributeDescriptors();
        FeatureIterator<SimpleFeature> iter = collection.features();
        try {
            ReferencedEnvelope bounds = null;
            while (iter.hasNext()) {
                try {
                    SimpleFeature newFeature;
                    try {
                        SimpleFeature f = iter.next();
                        String nextFid = ts.nextFid(schema.getTypeName());
                        Object[] values = f.getAttributes().toArray();
                        build.addAll(values);
                        newFeature = build.buildFeature(nextFid);
                        r.add(newFeature.getIdentifier());
                    }
                    catch (IllegalAttributeException e) {
                        throw new IOException(e.getLocalizedMessage());
                    }
                    for (int i = 0; i < atrs.size(); ++i) {
                        Object geom;
                        AttributeDescriptor att = (AttributeDescriptor)atrs.get(i);
                        if (!(att instanceof GeometryDescriptor) || !((geom = newFeature.getAttribute(i)) instanceof Geometry)) continue;
                        Geometry g = (Geometry)geom;
                        CoordinateReferenceSystem cs = ((GeometryDescriptor)att).getCoordinateReferenceSystem();
                        if (g == null) continue;
                        if (cs != null && !cs.getIdentifiers().isEmpty()) {
                            g.setUserData(((ReferenceIdentifier)cs.getIdentifiers().iterator().next()).toString());
                        }
                        if (bounds == null) {
                            bounds = new ReferencedEnvelope(g.getEnvelopeInternal(), schema.getCoordinateReferenceSystem());
                            continue;
                        }
                        bounds.expandToInclude(g.getEnvelopeInternal());
                    }
                    ts.addAction(schema.getTypeName(), new Action.InsertAction(newFeature));
                }
                catch (NoSuchElementException e) {
                    WFS_1_0_0_DataStore.LOGGER.warning(e.toString());
                    throw new IOException(e.toString());
                }
            }
            if (bounds == null) {
                bounds = new ReferencedEnvelope(this.getSchema().getCoordinateReferenceSystem());
                ((WFS_1_0_0_DataStore)this.getDataStore()).listenerManager.fireFeaturesRemoved(schema.getTypeName(), this.getTransaction(), bounds, false);
            } else {
                ((WFS_1_0_0_DataStore)this.getDataStore()).listenerManager.fireFeaturesRemoved(schema.getTypeName(), this.getTransaction(), bounds, false);
            }
        }
        finally {
            iter.close();
        }
        if (this.trans == Transaction.AUTO_COMMIT) {
            ts.commit();
            String[] fids = ts.getFids(schema.getTypeName());
            int i = 0;
            for (String fid : fids) {
                FeatureId identifier = (FeatureId)r.get(i);
                if (identifier instanceof FeatureIdImpl) {
                    ((FeatureIdImpl)identifier).setID(fid);
                }
                ++i;
            }
            return r;
        }
        return r;
    }

    @Override
    public void removeFeatures(Filter filter2) throws IOException {
        Filter filter = this.ds.processFilter(filter2);
        WFSTransactionState ts = null;
        ts = this.trans == Transaction.AUTO_COMMIT ? new WFSTransactionState(this.ds) : (WFSTransactionState)this.trans.getState(this.ds);
        ts.addAction(this.getSchema().getTypeName(), new Action.DeleteAction(this.getSchema().getTypeName(), filter));
        ((WFS_1_0_0_DataStore)this.getDataStore()).listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), null, false);
        if (this.trans == Transaction.AUTO_COMMIT) {
            ts.commit();
        }
    }

    @Override
    public void modifyFeatures(Name[] names, Object[] value, Filter filter2) throws IOException {
        Filter filter = this.ds.processFilter(filter2);
        WFSTransactionState ts = null;
        ts = this.trans == Transaction.AUTO_COMMIT ? new WFSTransactionState(this.ds) : (WFSTransactionState)this.trans.getState(this.ds);
        HashMap<String, Object> props = new HashMap<String, Object>();
        ReferencedEnvelope bounds = null;
        for (int i = 0; i < names.length; ++i) {
            if (names[i] instanceof GeometryDescriptor) {
                Geometry g = (Geometry)value[i];
                CoordinateReferenceSystem cs = ((GeometryDescriptor)names[i]).getCoordinateReferenceSystem();
                if (cs != null && !cs.getIdentifiers().isEmpty()) {
                    g.setUserData(((ReferenceIdentifier)cs.getIdentifiers().iterator().next()).toString());
                }
                g.setUserData(((ReferenceIdentifier)cs.getIdentifiers().iterator().next()).toString());
                if (cs != null && !cs.getIdentifiers().isEmpty()) {
                    g.setUserData(((ReferenceIdentifier)cs.getIdentifiers().iterator().next()).toString());
                }
                if (g == null) continue;
                if (bounds == null) {
                    bounds = new ReferencedEnvelope(g.getEnvelopeInternal(), cs);
                } else {
                    bounds.expandToInclude(g.getEnvelopeInternal());
                }
            }
            props.put(names[i].getLocalPart(), value[i]);
        }
        ts.addAction(this.getSchema().getTypeName(), new Action.UpdateAction(this.getSchema().getTypeName(), filter, props));
        if (bounds == null) {
            bounds = new ReferencedEnvelope(this.getSchema().getCoordinateReferenceSystem());
            ((WFS_1_0_0_DataStore)this.getDataStore()).listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), bounds, false);
        } else {
            ((WFS_1_0_0_DataStore)this.getDataStore()).listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), bounds, false);
        }
        if (this.trans == Transaction.AUTO_COMMIT) {
            ts.commit();
        }
    }

    @Override
    public final void modifyFeatures(AttributeDescriptor type, Object value, Filter filter) throws IOException {
        Name attributeName = type.getName();
        this.modifyFeatures(attributeName, value, filter);
    }

    @Override
    public void modifyFeatures(Name type, Object value, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{type}, new Object[]{value}, filter);
    }

    @Override
    public final void modifyFeatures(AttributeDescriptor[] type, Object[] value, Filter filter) throws IOException {
        Name[] attributeNames = new Name[type.length];
        for (int i = 0; i < type.length; ++i) {
            attributeNames[i] = type[i].getName();
        }
        this.modifyFeatures(attributeNames, value, filter);
    }

    @Override
    public void modifyFeatures(String name, Object attributeValue, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{new NameImpl(name)}, new Object[]{attributeValue}, filter);
    }

    @Override
    public void modifyFeatures(String[] names, Object[] values, Filter filter) throws IOException {
        Name[] attributeNames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            attributeNames[i] = new NameImpl(names[i]);
        }
        this.modifyFeatures(attributeNames, values, filter);
    }

    @Override
    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        WFSTransactionState ts = null;
        ts = this.trans == Transaction.AUTO_COMMIT ? new WFSTransactionState(this.ds) : (WFSTransactionState)this.trans.getState(this.ds);
        ts.addAction(this.getSchema().getTypeName(), new Action.DeleteAction(this.getSchema().getTypeName(), (Filter)Filter.INCLUDE));
        ReferencedEnvelope bounds = null;
        while (reader.hasNext()) {
            try {
                SimpleFeature f = reader.next();
                List atrs = f.getFeatureType().getAttributeDescriptors();
                for (int i = 0; i < atrs.size(); ++i) {
                    if (!(atrs.get(i) instanceof GeometryDescriptor)) continue;
                    Geometry g = (Geometry)f.getAttribute(i);
                    CoordinateReferenceSystem cs = ((GeometryDescriptor)atrs.get(i)).getCoordinateReferenceSystem();
                    if (cs != null && !cs.getIdentifiers().isEmpty()) {
                        g.setUserData(((ReferenceIdentifier)cs.getIdentifiers().iterator().next()).toString());
                    }
                    if (g == null) continue;
                    if (bounds == null) {
                        bounds = new ReferencedEnvelope(g.getEnvelopeInternal(), cs);
                        continue;
                    }
                    bounds.expandToInclude(g.getEnvelopeInternal());
                }
                ts.addAction(this.getSchema().getTypeName(), new Action.InsertAction(f));
            }
            catch (NoSuchElementException e) {
                WFS_1_0_0_DataStore.LOGGER.warning(e.toString());
            }
            catch (IllegalAttributeException e) {
                WFS_1_0_0_DataStore.LOGGER.warning(e.toString());
            }
        }
        if (bounds == null) {
            bounds = new ReferencedEnvelope(this.getSchema().getCoordinateReferenceSystem());
            ((WFS_1_0_0_DataStore)this.getDataStore()).listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), bounds, false);
        } else {
            ((WFS_1_0_0_DataStore)this.getDataStore()).listenerManager.fireFeaturesRemoved(this.getSchema().getTypeName(), this.getTransaction(), bounds, false);
        }
        if (this.trans == Transaction.AUTO_COMMIT) {
            ts.commit();
        }
    }

    @Override
    public void setTransaction(Transaction transaction) {
        WFSTransactionState ts;
        if (transaction == null) {
            throw new NullPointerException("Should this not be Transaction.AutoCommit?");
        }
        this.trans = transaction;
        if (this.trans != Transaction.AUTO_COMMIT && (ts = (WFSTransactionState)this.trans.getState(this.ds)) == null) {
            this.trans.putState(this.ds, new WFSTransactionState(this.ds));
        }
    }
}

