/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import org.geotools.data.ResourceInfo;
import org.geotools.data.wfs.v1_1_0.WFS_1_1_0_DataStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CapabilitiesResourceInfo
implements ResourceInfo {
    private WFS_1_1_0_DataStore wfs;
    private String typeName;

    public CapabilitiesResourceInfo(String typeName, WFS_1_1_0_DataStore service) {
        this.typeName = typeName;
        this.wfs = service;
    }

    @Override
    public String getTitle() {
        return this.wfs.getFeatureTypeTitle(this.typeName);
    }

    @Override
    public String getDescription() {
        return this.wfs.getFeatureTypeAbstract(this.typeName);
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.wfs.getFeatureTypeBounds(this.typeName);
    }

    @Override
    public CoordinateReferenceSystem getCRS() {
        return this.wfs.getFeatureTypeCRS(this.typeName);
    }

    @Override
    public Set<String> getKeywords() {
        return this.wfs.getFeatureTypeKeywords(this.typeName);
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    @Override
    public URI getSchema() {
        URL describeFeatureTypeURL = this.wfs.getDescribeFeatureTypeURL(this.typeName);
        if (describeFeatureTypeURL == null) {
            return null;
        }
        try {
            return describeFeatureTypeURL.toURI();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

