/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_1_0;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.ResultTypeType;
import net.opengis.wfs.impl.GetFeatureTypeImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.geotools.data.wfs.protocol.wfs.GetFeature;
import org.geotools.data.wfs.protocol.wfs.WFSProtocol;
import org.geotools.data.wfs.v1_1_0.DefaultWFSStrategy;
import org.geotools.data.wfs.v1_1_0.WFSStrategy;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.Capabilities;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.xml.EMFUtils;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Or;
import org.opengis.filter.spatial.BinarySpatialOperator;

public class CubeWerxStrategy
extends DefaultWFSStrategy {
    public WFSStrategy.RequestComponents createGetFeatureRequest(WFSProtocol wfs, GetFeature query) throws IOException {
        WFSStrategy.RequestComponents parts = super.createGetFeatureRequest(wfs, query);
        GetFeatureType serverRequest = parts.getServerRequest();
        serverRequest.setResultType(null);
        parts.setServerRequest(serverRequest);
        CubeWerxGetFeatureType nonResultTypeRequest = new CubeWerxGetFeatureType();
        EMFUtils.copy((EObject)serverRequest, (EObject)nonResultTypeRequest);
        nonResultTypeRequest.setResultType(null);
        parts.setServerRequest((GetFeatureType)nonResultTypeRequest);
        parts.getKvpParameters().remove("RESULTTYPE");
        return parts;
    }

    public Filter[] splitFilters(Capabilities caps, Filter queryFilter) {
        Filter postFilter;
        IncludeFilter serverFilter;
        if (!(queryFilter instanceof BinaryLogicOperator)) {
            return super.splitFilters(caps, queryFilter);
        }
        int spatialFiltersCount = 0;
        List children = ((BinaryLogicOperator)queryFilter).getChildren();
        for (Filter f : children) {
            if (!(f instanceof BinarySpatialOperator)) continue;
            ++spatialFiltersCount;
        }
        if (spatialFiltersCount <= 1) {
            return super.splitFilters(caps, queryFilter);
        }
        if (queryFilter instanceof Or) {
            serverFilter = Filter.INCLUDE;
            postFilter = queryFilter;
        } else {
            ArrayList<Filter> serverChild = new ArrayList<Filter>();
            ArrayList<Filter> postChild = new ArrayList<Filter>();
            boolean spatialAdded = false;
            for (Filter f : children) {
                if (f instanceof BinarySpatialOperator) {
                    if (spatialAdded) {
                        postChild.add(f);
                        continue;
                    }
                    serverChild.add(f);
                    spatialAdded = true;
                    continue;
                }
                serverChild.add(f);
            }
            FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
            serverFilter = ff.and(serverChild);
            postFilter = ff.and(postChild);
            SimplifyingFilterVisitor sfv = new SimplifyingFilterVisitor();
            serverFilter = (Filter)serverFilter.accept((FilterVisitor)sfv, null);
            postFilter = (Filter)postFilter.accept((FilterVisitor)sfv, null);
        }
        return new Filter[]{serverFilter, postFilter};
    }

    private static class CubeWerxGetFeatureType
    extends GetFeatureTypeImpl {
        private CubeWerxGetFeatureType() {
        }

        public void setResultType(ResultTypeType newResultType) {
            ResultTypeType oldResultType = this.resultType;
            this.resultType = newResultType;
            boolean oldResultTypeESet = this.resultTypeESet;
            this.resultTypeESet = true;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldResultType, (Object)this.resultType, !oldResultTypeESet));
            }
        }
    }
}

