/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.layer.wms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.Dispatcher;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.TileResponseReceiver;
import org.geowebcache.layer.wms.FakeHttpServletRequest;
import org.geowebcache.layer.wms.FakeHttpServletResponse;
import org.geowebcache.layer.wms.WMSLayer;
import org.geowebcache.layer.wms.WMSSourceHelper;
import org.geowebcache.mime.XMLMime;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSGeoServerHelper
extends WMSSourceHelper {
    private static Logger log = Logging.getLogger((String)WMSGeoServerHelper.class.toString());
    Dispatcher gsDispatcher;

    public WMSGeoServerHelper(Dispatcher gsDispatcher) {
        this.gsDispatcher = gsDispatcher;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void makeRequest(TileResponseReceiver tileRespRecv, WMSLayer layer, Map<String, String> wmsParams, String expectedMimeType, Resource target) throws GeoWebCacheException {
        if (tileRespRecv instanceof ConveyorTile && ((ConveyorTile)tileRespRecv).getMimeType() == XMLMime.kml) {
            wmsParams.put("format_options=", "regionateBy:auto");
        }
        HttpServletRequest actualRequest = null;
        HttpServletResponse actualResponse = null;
        Cookie[] cookies = null;
        if (tileRespRecv instanceof Conveyor) {
            actualRequest = ((Conveyor)tileRespRecv).servletReq;
            actualResponse = ((Conveyor)tileRespRecv).servletResp;
            cookies = actualRequest.getCookies();
        }
        FakeHttpServletRequest req = new FakeHttpServletRequest(wmsParams, cookies);
        FakeHttpServletResponse resp = new FakeHttpServletResponse();
        try {
            this.gsDispatcher.handleRequest((HttpServletRequest)req, (HttpServletResponse)resp);
        }
        catch (Exception e) {
            log.fine(e.getMessage());
            throw new GeoWebCacheException("Problem communicating with GeoServer" + e.getMessage());
        }
        if (actualResponse != null) {
            for (Cookie c : cookies = resp.getCachedCookies()) {
                actualResponse.addCookie(c);
            }
        }
        if (!super.mimeStringCheck(expectedMimeType, resp.getContentType())) {
            log.severe("Unexpected response from GeoServer for request: " + wmsParams);
            throw new GeoWebCacheException("Unexpected response from GeoServer for request " + wmsParams);
        }
        int responseCode = resp.getResponseCode();
        tileRespRecv.setStatus(responseCode);
        if (responseCode != 200) {
            if (responseCode != 204) throw new GeoWebCacheException("Unexpected response from GeoServer for request " + wmsParams + ", got response code " + responseCode);
            return;
        }
        byte[] bytes = resp.getBytes();
        try {
            target.transferFrom(Channels.newChannel(new ByteArrayInputStream(bytes)));
        }
        catch (IOException e) {
            throw new GeoWebCacheException((Throwable)e);
        }
        Assert.isTrue((target.getSize() == (long)bytes.length ? 1 : 0) != 0);
    }
}

