/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.xsd.XSDSchema;
import org.geotools.xml.Configuration;
import org.geotools.xml.impl.ParserHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.NamespaceSupport;

public class Parser {
    private ParserHandler handler;
    private SAXParser parser;
    private InputStream input;

    public Parser(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.handler = new ParserHandler(configuration);
        configuration.setupParser(this);
    }

    public Parser(Configuration configuration, String input) throws IOException, URISyntaxException {
        this(configuration, new BufferedInputStream(new FileInputStream(new File(new URI(input)))));
    }

    public Parser(Configuration configuration, InputStream input) {
        this(configuration);
        this.input = input;
    }

    ParserHandler getParserHandler() {
        return this.handler;
    }

    public Object parse() throws IOException, SAXException, ParserConfigurationException {
        return this.parse(this.input);
    }

    public Object parse(InputStream input) throws IOException, SAXException, ParserConfigurationException {
        return this.parse(new InputSource(input));
    }

    public Object parse(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        return this.parse(new InputSource(reader));
    }

    public Object parse(Source source) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        StreamResult result = new StreamResult(new ByteArrayOutputStream());
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer tx = tf.newTransformer();
        tx.transform(source, result);
        return this.parse(new ByteArrayInputStream(((ByteArrayOutputStream)result.getOutputStream()).toByteArray()));
    }

    public Object parse(InputSource source) throws IOException, SAXException, ParserConfigurationException {
        this.parser = this.parser();
        this.parser.setContentHandler((ContentHandler)this.handler);
        this.parser.setErrorHandler((ErrorHandler)this.handler);
        this.parser.parse(source);
        return this.handler.getValue();
    }

    public void setStrict(boolean strict) {
        this.handler.setStrict(strict);
    }

    public void setValidating(boolean validating) {
        this.handler.setValidating(validating);
    }

    public boolean isValidating() {
        return this.handler.isValidating();
    }

    public void setFailOnValidationError(boolean fail) {
        this.handler.setFailOnValidationError(fail);
    }

    public boolean isFailOnValidationError() {
        return this.handler.isFailOnValidationError();
    }

    public void setHandleMixedContent(boolean handleMixedContent) {
        this.handler.setHandleMixedContent(handleMixedContent);
    }

    public boolean isHandleMixedContent() {
        return this.handler.isHandleMixedContent();
    }

    public List getValidationErrors() {
        return this.handler.getValidationErrors();
    }

    public void validate(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.validate(new InputSource(in));
    }

    public void validate(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.validate(new InputSource(reader));
    }

    public void validate(InputSource source) throws IOException, SAXException, ParserConfigurationException {
        SAXParser parser = this.parser(true);
        parser.setContentHandler((ContentHandler)this.handler.getValidator());
        parser.setErrorHandler((ErrorHandler)this.handler.getValidator());
        parser.parse(source);
    }

    public XSDSchema[] getSchemas() {
        if (this.handler != null) {
            return this.handler.getSchemas();
        }
        return null;
    }

    public NamespaceSupport getNamespaces() {
        return this.handler.getNamespaceSupport();
    }

    protected SAXParser parser() throws ParserConfigurationException, SAXException {
        return this.parser(this.isValidating());
    }

    protected SAXParser parser(boolean validate) throws ParserConfigurationException, SAXException {
        SAXParser parser = new SAXParser();
        parser.setFeature("http://xml.org/sax/features/namespaces", true);
        if (validate) {
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        }
        StringBuffer schemaLocation = new StringBuffer();
        for (Configuration dependency : this.handler.getConfiguration().allDependencies()) {
            if ("http://www.w3.org/2001/XMLSchema".equals(dependency.getNamespaceURI())) continue;
            if (schemaLocation.length() > 0) {
                schemaLocation.append(" ");
            }
            schemaLocation.append(dependency.getNamespaceURI());
            schemaLocation.append(" ");
            schemaLocation.append(dependency.getSchemaFileURL());
        }
        parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)schemaLocation.toString());
        return parser;
    }

    public static interface Properties {
        public static final QName PARSE_UNKNOWN_ELEMENTS = new QName("http://www.geotools.org", "parseUnknownElements");
        public static final QName PARSE_UNKNOWN_ATTRIBUTES = new QName("http://www.geotools.org", "parseUnknownAttributes");
        public static final QName IGNORE_SCHEMA_LOCATION = new QName("http://www.geotools.org", "ignoreSchemaLocation");
    }
}

