/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.geotools.factory.Hints;
import org.geotools.util.CommonsConverterFactory;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.xml.impl.DatatypeConverterImpl;

public class XmlConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (String.class.equals((Object)source)) {
            return new XmlConverter();
        }
        return null;
    }

    static class XmlConverter
    implements Converter {
        XmlConverter() {
        }

        public Object convert(Object source, Class target) throws Exception {
            Calendar date;
            String value;
            block15: {
                value = (String)source;
                if (!Calendar.class.equals((Object)target) && !Date.class.isAssignableFrom(target)) {
                    return null;
                }
                try {
                    Converter converter = new CommonsConverterFactory().createConverter(value.getClass(), target, null);
                    if (converter == null) break block15;
                    Object converted = null;
                    try {
                        converted = converter.convert(source, target);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (converted != null) {
                        return converted;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                try {
                    date = DatatypeConverterImpl.getInstance().parseDateTime(value);
                }
                catch (Exception e) {
                    date = DatatypeConverterImpl.getInstance().parseDate(value);
                }
            }
            catch (Exception e) {
                date = DatatypeConverterImpl.getInstance().parseTime(value);
            }
            if (Calendar.class.equals((Object)target)) {
                return date;
            }
            if (Date.class.isAssignableFrom(target)) {
                Date time = date.getTime();
                if (java.sql.Date.class.equals((Object)target)) {
                    return new java.sql.Date(time.getTime());
                }
                if (Time.class.equals((Object)target)) {
                    return new Time(time.getTime());
                }
                if (Timestamp.class.equals((Object)target)) {
                    return new Timestamp(time.getTime());
                }
                return time;
            }
            return null;
        }
    }
}

