/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.util.List;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdateSequenceListener
implements CatalogListener,
ConfigurationListener {
    GeoServer geoServer;
    boolean updating = false;

    public UpdateSequenceListener(GeoServer geoServer) {
        this.geoServer = geoServer;
        geoServer.getCatalog().addListener(this);
        geoServer.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void incrementSequence() {
        if (this.updating) {
            return;
        }
        try {
            this.updating = true;
            GeoServerInfo gsInfo = this.geoServer.getGlobal();
            gsInfo.setUpdateSequence(gsInfo.getUpdateSequence() + 1L);
            this.geoServer.save(gsInfo);
        }
        finally {
            this.updating = false;
        }
    }

    @Override
    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
        this.incrementSequence();
    }

    @Override
    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
        this.incrementSequence();
    }

    @Override
    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
    }

    @Override
    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        this.incrementSequence();
    }

    @Override
    public void reloaded() {
    }

    @Override
    public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
    }

    @Override
    public void handleLoggingChange(LoggingInfo logging, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
    }

    @Override
    public void handlePostGlobalChange(GeoServerInfo global) {
        this.incrementSequence();
    }

    @Override
    public void handlePostLoggingChange(LoggingInfo logging) {
    }

    @Override
    public void handlePostServiceChange(ServiceInfo service) {
        this.incrementSequence();
    }

    @Override
    public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
    }
}

