/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.LocalLayer;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.ResourceAccessManagerWrapper;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.opengis.filter.Filter;
import org.springframework.security.Authentication;

public class LocalWorkspaceResourceAccessManager
extends ResourceAccessManagerWrapper {
    private DataAccessLimits hide(ResourceInfo info) {
        if (info instanceof FeatureTypeInfo) {
            return new VectorAccessLimits(CatalogMode.HIDE, null, (Filter)Filter.EXCLUDE, null, (Filter)Filter.EXCLUDE);
        }
        if (info instanceof CoverageInfo) {
            return new CoverageAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE, null, null);
        }
        if (info instanceof WMSLayerInfo) {
            return new WMSAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE, null, false);
        }
        return new DataAccessLimits(CatalogMode.HIDE, (Filter)Filter.EXCLUDE);
    }

    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer) {
        if (this.hideLayer(layer) || this.hideResource(layer.getResource())) {
            return this.hide(layer.getResource());
        }
        return super.getAccessLimits(user, layer);
    }

    public DataAccessLimits getAccessLimits(Authentication user, ResourceInfo resource) {
        if (this.hideResource(resource)) {
            return this.hide(resource);
        }
        return super.getAccessLimits(user, resource);
    }

    public WorkspaceAccessLimits getAccessLimits(Authentication user, WorkspaceInfo workspace) {
        if (this.hideWorkspace(workspace)) {
            return new WorkspaceAccessLimits(CatalogMode.HIDE, false, false);
        }
        return super.getAccessLimits(user, workspace);
    }

    private boolean hideLayer(LayerInfo layer) {
        return LocalLayer.get() != null && !LocalLayer.get().equals(layer);
    }

    private boolean hideResource(ResourceInfo resource) {
        if (LocalLayer.get() != null) {
            for (LayerInfo l : resource.getCatalog().getLayers(resource)) {
                if (l.equals(LocalLayer.get())) continue;
                return true;
            }
        }
        return this.hideWorkspace(resource.getStore().getWorkspace());
    }

    private boolean hideWorkspace(WorkspaceInfo workspace) {
        return LocalWorkspace.get() != null && !LocalWorkspace.get().equals(workspace);
    }
}

