/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingCoverageInfo;
import org.geoserver.security.decorators.SecuredCoverageStoreInfo;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.util.ProgressListener;

public class SecuredCoverageInfo
extends DecoratingCoverageInfo {
    WrapperPolicy policy;

    public SecuredCoverageInfo(CoverageInfo delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    public GridCoverage getGridCoverage(ProgressListener listener, Hints hints) throws IOException {
        if (this.policy.level == AccessLevel.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        GridCoverageReader reader = this.getGridCoverageReader(listener, hints);
        return this.getCatalog().getResourcePool().getGridCoverage(this, reader, null, hints);
    }

    public GridCoverage getGridCoverage(ProgressListener listener, ReferencedEnvelope envelope, Hints hints) throws IOException {
        if (this.policy.level == AccessLevel.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        GridCoverageReader reader = this.getGridCoverageReader(listener, hints);
        return this.getCatalog().getResourcePool().getGridCoverage(this, reader, envelope, hints);
    }

    public GridCoverageReader getGridCoverageReader(ProgressListener listener, Hints hints) throws IOException {
        if (this.policy.level == AccessLevel.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        GridCoverageReader reader = super.getGridCoverageReader(listener, hints);
        return (GridCoverageReader)SecuredObjects.secure(reader, this.policy);
    }

    public CoverageStoreInfo getStore() {
        return new SecuredCoverageStoreInfo(super.getStore(), this.policy);
    }
}

