/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import java.util.logging.Logger;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.data.DataAccess;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuredFeatureSource<T extends FeatureType, F extends Feature>
extends DecoratingFeatureSource<T, F> {
    static final Logger LOGGER = Logging.getLogger(SecuredFeatureSource.class);
    WrapperPolicy policy;

    protected SecuredFeatureSource(FeatureSource<T, F> delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public DataAccess<T, F> getDataStore() {
        DataAccess store = ((FeatureSource)this.delegate).getDataStore();
        if (store == null) {
            return null;
        }
        return (DataAccess)SecuredObjects.secure(store, this.policy);
    }

    @Override
    public FeatureCollection<T, F> getFeatures() throws IOException {
        FeatureCollection fc = ((FeatureSource)this.delegate).getFeatures(this.getReadQuery());
        if (fc == null) {
            return null;
        }
        return (FeatureCollection)SecuredObjects.secure(fc, this.policy);
    }

    @Override
    public FeatureCollection<T, F> getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new Query(null, filter));
    }

    @Override
    public FeatureCollection<T, F> getFeatures(Query query) throws IOException {
        Query readQuery = this.getReadQuery();
        Query mixed = DataUtilities.mixQueries((Query)query, (Query)readQuery, (String)query.getHandle());
        FeatureCollection fc = ((FeatureSource)this.delegate).getFeatures(mixed);
        if (fc == null) {
            return null;
        }
        return (FeatureCollection)SecuredObjects.secure(fc, this.policy);
    }

    protected Query getReadQuery() {
        if (this.policy.getAccessLevel() == AccessLevel.HIDDEN || this.policy.getAccessLevel() == AccessLevel.METADATA) {
            return new Query(null, (Filter)Filter.EXCLUDE);
        }
        if (this.policy.getLimits() == null) {
            return Query.ALL;
        }
        if (this.policy.getLimits() instanceof VectorAccessLimits) {
            VectorAccessLimits val = (VectorAccessLimits)this.policy.getLimits();
            Request request = (Request)Dispatcher.REQUEST.get();
            if (request != null && request.getService().equalsIgnoreCase("WFS") && request.getRequest().equalsIgnoreCase("Transaction")) {
                return val.getWriteQuery();
            }
            return val.getReadQuery();
        }
        throw new IllegalArgumentException("SecureFeatureSources has been fed with unexpected AccessLimits class " + this.policy.getLimits().getClass());
    }
}

