/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.data.DataUtilities;
import org.geotools.util.logging.Logging;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SLDValidator {
    static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver");

    public List validateSLD(InputStream xml, String baseUrl) {
        return this.validateSLD(new InputSource(xml), baseUrl);
    }

    public static String getErrorMessage(InputStream xml, List errors) {
        return SLDValidator.getErrorMessage(new InputStreamReader(xml), errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getErrorMessage(Reader xml, List errors) {
        BufferedReader reader = null;
        StringBuffer result = new StringBuffer();
        result.append("Your SLD is not valid.\n");
        result.append("Most common problems are: \n(1) no namespaces - use <ows:GetMap>, <sld:Rule>, <ogc:Filter>, <gml:Point>  - the part before the ':' is important\n");
        result.append("(2) capitialization - use '<And>' not '<and>' \n");
        result.append("(3) Order - The order of elements is important \n");
        result.append("(4) Make sure your first tag imports the correct namespaces.  ie. xmlns:sld=\"http://www.opengis.net/sld\" for EVERY NAMESPACE \n");
        result.append("\n");
        try {
            SAXParseException sax;
            reader = new BufferedReader(xml);
            String line = reader.readLine();
            int linenumber = 1;
            int exceptionNum = 0;
            if (errors.size() > 0 && (sax = (SAXParseException)errors.get(0)).getLineNumber() < 0) {
                result.append("   INVALID XML: " + sax.getLocalizedMessage() + "\n");
                result.append(" \n");
                exceptionNum = 1;
            }
            while (line != null) {
                line.replace('\n', ' ');
                line.replace('\r', ' ');
                String header = linenumber + ": ";
                result.append(header + line + "\n");
                boolean keep_going = true;
                while (keep_going) {
                    if (exceptionNum < errors.size()) {
                        SAXParseException sax2 = (SAXParseException)errors.get(exceptionNum);
                        if (sax2.getLineNumber() <= linenumber) {
                            String head = "---------------------".substring(0, header.length() - 1);
                            String body = "--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------";
                            int colNum = sax2.getColumnNumber();
                            if (colNum < 1) {
                                colNum = 1;
                            }
                            if (colNum > body.length() && colNum > (body = body + body + body + body + body + body).length()) {
                                colNum = body.length();
                            }
                            result.append(head + body.substring(0, colNum - 1) + "^\n");
                            result.append("       (line " + sax2.getLineNumber() + ", column " + sax2.getColumnNumber() + ")" + sax2.getLocalizedMessage() + "\n");
                            ++exceptionNum;
                            continue;
                        }
                        keep_going = false;
                        continue;
                    }
                    keep_going = false;
                }
                line = reader.readLine();
                ++linenumber;
            }
            for (int t = exceptionNum; t < errors.size(); ++t) {
                SAXParseException sax3 = (SAXParseException)errors.get(t);
                result.append("       (line " + sax3.getLineNumber() + ", column " + sax3.getColumnNumber() + ")" + sax3.getLocalizedMessage() + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result.toString();
    }

    public List validateSLD(InputSource xml, String baseURL) {
        SAXParser parser = new SAXParser();
        try {
            String schemaUrl = null;
            if (baseURL != null) {
                String schemaLoction = ResponseUtils.buildSchemaURL((String)baseURL, (String)"sld/StyledLayerDescriptor.xsd");
                URL schemaFile = new URL(schemaLoction);
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info(new StringBuffer("Validating SLD with ").append(schemaFile.toString()).toString());
                }
                schemaUrl = schemaFile.toString();
            } else {
                File file = ((GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class)).find(new String[]{"schemas", "sld", "StyledLayerDescriptor.xsd"});
                if (file == null) {
                    throw new RuntimeException("base url not specified and unable to find internal SLD schema");
                }
                schemaUrl = DataUtilities.fileToURL((File)file).toString();
            }
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)schemaUrl);
            parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)("http://www.opengis.net/sld " + schemaUrl));
            Validator handler = new Validator();
            parser.setErrorHandler((ErrorHandler)handler);
            parser.parse(xml);
            return handler.errors;
        }
        catch (IOException ioe) {
            ArrayList<SAXParseException> al = new ArrayList<SAXParseException>();
            al.add(new SAXParseException(ioe.getLocalizedMessage(), null));
            return al;
        }
        catch (SAXException e) {
            ArrayList<SAXParseException> al = new ArrayList<SAXParseException>();
            al.add(new SAXParseException(e.getLocalizedMessage(), null));
            return al;
        }
    }

    private class Validator
    extends DefaultHandler {
        public ArrayList errors = new ArrayList();

        private Validator() {
        }

        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.errors.add(exception);
        }

        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

