/*
 * Decompiled with CFR 0.152.
 */
package jaitools.imageutils;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Random;
import javax.media.jai.BorderExtender;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

public class SamplingBorderExtender
extends BorderExtender {
    private final int maxDistance;
    private final Random rand;

    public SamplingBorderExtender(int maxDistance) {
        this.maxDistance = maxDistance;
        this.rand = new Random();
    }

    public void extend(WritableRaster raster, PlanarImage sourceImage) {
        int dataType = raster.getSampleModel().getDataType();
        switch (dataType) {
            case 0: {
                this.extendAsByte(raster, sourceImage);
                break;
            }
            case 2: {
                this.extendAsShort(raster, sourceImage);
                break;
            }
            case 1: {
                this.extendAsUShort(raster, sourceImage);
                break;
            }
            case 3: {
                this.extendAsInt(raster, sourceImage);
                break;
            }
            case 4: {
                this.extendAsFloat(raster, sourceImage);
                break;
            }
            case 5: {
                this.extendAsDouble(raster, sourceImage);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type");
            }
        }
    }

    private void extendAsByte(WritableRaster raster, PlanarImage sourceImage) {
        Rectangle bounds = sourceImage.getBounds();
        Rectangle samplingBounds = new Rectangle(0, 0, 2 * this.maxDistance + 1, 2 * this.maxDistance + 1);
        RandomIter srcIter = RandomIterFactory.create((RenderedImage)sourceImage, (Rectangle)bounds);
        int[] pixel = new int[raster.getNumBands()];
        int y = raster.getMinY();
        for (int ny = 0; ny < raster.getHeight(); ++ny) {
            int x = raster.getMinX();
            for (int nx = 0; nx < raster.getWidth(); ++nx) {
                if (!bounds.contains(x, y)) {
                    samplingBounds.setLocation(x - this.maxDistance, y - this.maxDistance);
                    Rectangle sourceSamplingBounds = samplingBounds.intersection(bounds);
                    int sx = this.rand.nextInt(sourceSamplingBounds.width) + sourceSamplingBounds.x;
                    int sy = this.rand.nextInt(sourceSamplingBounds.height) + sourceSamplingBounds.y;
                    srcIter.getPixel(sx, sy, pixel);
                    for (int b = 0; b < raster.getNumBands(); ++b) {
                        raster.setSample(x, y, b, pixel[b] & 0xFF);
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    private void extendAsShort(WritableRaster raster, PlanarImage sourceImage) {
        Rectangle bounds = sourceImage.getBounds();
        Rectangle samplingBounds = new Rectangle(0, 0, 2 * this.maxDistance + 1, 2 * this.maxDistance + 1);
        RandomIter srcIter = RandomIterFactory.create((RenderedImage)sourceImage, (Rectangle)bounds);
        int[] pixel = new int[raster.getNumBands()];
        int y = raster.getMinY();
        for (int ny = 0; ny < raster.getHeight(); ++ny) {
            int x = raster.getMinX();
            for (int nx = 0; nx < raster.getWidth(); ++nx) {
                if (!bounds.contains(x, y)) {
                    samplingBounds.setLocation(x - this.maxDistance, y - this.maxDistance);
                    Rectangle sourceSamplingBounds = samplingBounds.intersection(bounds);
                    int sx = this.rand.nextInt(sourceSamplingBounds.width) + sourceSamplingBounds.x;
                    int sy = this.rand.nextInt(sourceSamplingBounds.height) + sourceSamplingBounds.y;
                    srcIter.getPixel(sx, sy, pixel);
                    for (int b = 0; b < raster.getNumBands(); ++b) {
                        raster.setSample(x, y, b, this.clamp(pixel[b], Short.MIN_VALUE, Short.MAX_VALUE));
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    private void extendAsUShort(WritableRaster raster, PlanarImage sourceImage) {
        Rectangle bounds = sourceImage.getBounds();
        Rectangle samplingBounds = new Rectangle(0, 0, 2 * this.maxDistance + 1, 2 * this.maxDistance + 1);
        RandomIter srcIter = RandomIterFactory.create((RenderedImage)sourceImage, (Rectangle)bounds);
        int[] pixel = new int[raster.getNumBands()];
        int y = raster.getMinY();
        for (int ny = 0; ny < raster.getHeight(); ++ny) {
            int x = raster.getMinX();
            for (int nx = 0; nx < raster.getWidth(); ++nx) {
                if (!bounds.contains(x, y)) {
                    samplingBounds.setLocation(x - this.maxDistance, y - this.maxDistance);
                    Rectangle sourceSamplingBounds = samplingBounds.intersection(bounds);
                    int sx = this.rand.nextInt(sourceSamplingBounds.width) + sourceSamplingBounds.x;
                    int sy = this.rand.nextInt(sourceSamplingBounds.height) + sourceSamplingBounds.y;
                    srcIter.getPixel(sx, sy, pixel);
                    for (int b = 0; b < raster.getNumBands(); ++b) {
                        raster.setSample(x, y, b, pixel[b] & 0xFFFF);
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    private void extendAsInt(WritableRaster raster, PlanarImage sourceImage) {
        Rectangle bounds = sourceImage.getBounds();
        Rectangle samplingBounds = new Rectangle(0, 0, 2 * this.maxDistance + 1, 2 * this.maxDistance + 1);
        RandomIter srcIter = RandomIterFactory.create((RenderedImage)sourceImage, (Rectangle)bounds);
        int[] pixel = new int[raster.getNumBands()];
        int y = raster.getMinY();
        for (int ny = 0; ny < raster.getHeight(); ++ny) {
            int x = raster.getMinX();
            for (int nx = 0; nx < raster.getWidth(); ++nx) {
                if (!bounds.contains(x, y)) {
                    samplingBounds.setLocation(x - this.maxDistance, y - this.maxDistance);
                    Rectangle sourceSamplingBounds = samplingBounds.intersection(bounds);
                    int sx = this.rand.nextInt(sourceSamplingBounds.width) + sourceSamplingBounds.x;
                    int sy = this.rand.nextInt(sourceSamplingBounds.height) + sourceSamplingBounds.y;
                    srcIter.getPixel(sx, sy, pixel);
                    raster.setPixel(x, y, pixel);
                }
                ++x;
            }
            ++y;
        }
    }

    private void extendAsFloat(WritableRaster raster, PlanarImage sourceImage) {
        Rectangle bounds = sourceImage.getBounds();
        Rectangle samplingBounds = new Rectangle(0, 0, 2 * this.maxDistance + 1, 2 * this.maxDistance + 1);
        RandomIter srcIter = RandomIterFactory.create((RenderedImage)sourceImage, (Rectangle)bounds);
        float[] pixel = new float[raster.getNumBands()];
        int y = raster.getMinY();
        for (int ny = 0; ny < raster.getHeight(); ++ny) {
            int x = raster.getMinX();
            for (int nx = 0; nx < raster.getWidth(); ++nx) {
                if (!bounds.contains(x, y)) {
                    samplingBounds.setLocation(x - this.maxDistance, y - this.maxDistance);
                    Rectangle sourceSamplingBounds = samplingBounds.intersection(bounds);
                    int sx = this.rand.nextInt(sourceSamplingBounds.width) + sourceSamplingBounds.x;
                    int sy = this.rand.nextInt(sourceSamplingBounds.height) + sourceSamplingBounds.y;
                    srcIter.getPixel(sx, sy, pixel);
                    raster.setPixel(x, y, pixel);
                }
                ++x;
            }
            ++y;
        }
    }

    private void extendAsDouble(WritableRaster raster, PlanarImage sourceImage) {
        Rectangle bounds = sourceImage.getBounds();
        Rectangle samplingBounds = new Rectangle(0, 0, 2 * this.maxDistance + 1, 2 * this.maxDistance + 1);
        RandomIter srcIter = RandomIterFactory.create((RenderedImage)sourceImage, (Rectangle)bounds);
        double[] pixel = new double[raster.getNumBands()];
        int y = raster.getMinY();
        for (int ny = 0; ny < raster.getHeight(); ++ny) {
            int x = raster.getMinX();
            for (int nx = 0; nx < raster.getWidth(); ++nx) {
                if (!bounds.contains(x, y)) {
                    samplingBounds.setLocation(x - this.maxDistance, y - this.maxDistance);
                    Rectangle sourceSamplingBounds = samplingBounds.intersection(bounds);
                    int sx = this.rand.nextInt(sourceSamplingBounds.width) + sourceSamplingBounds.x;
                    int sy = this.rand.nextInt(sourceSamplingBounds.height) + sourceSamplingBounds.y;
                    srcIter.getPixel(sx, sy, pixel);
                    raster.setPixel(x, y, pixel);
                }
                ++x;
            }
            ++y;
        }
    }

    private int clamp(int value, int min, int max) {
        return Math.max(Math.min(value, max), min);
    }
}

