/*
 * Decompiled with CFR 0.152.
 */
package jaitools.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import jaitools.jts.AbstractSmoother;
import java.util.ArrayList;

public class PolygonSmoother
extends AbstractSmoother {
    public PolygonSmoother() {
        super(new GeometryFactory());
    }

    public PolygonSmoother(GeometryFactory geomFactory) {
        super(geomFactory);
    }

    private Coordinate[][] getControlPoints(Coordinate[] coords, int N, double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("alpha must be a value between 0 and 1 inclusive");
        }
        Coordinate[][] ctrl = new Coordinate[N][2];
        Coordinate[] v = new Coordinate[3];
        Coordinate[] mid = new Coordinate[]{new Coordinate(), new Coordinate()};
        Coordinate anchor = new Coordinate();
        double[] vdist = new double[2];
        v[1] = coords[N - 1];
        v[2] = coords[0];
        mid[1].x = (v[1].x + v[2].x) / 2.0;
        mid[1].y = (v[1].y + v[2].y) / 2.0;
        vdist[1] = v[1].distance(v[2]);
        for (int i = 0; i < N; ++i) {
            v[0] = v[1];
            v[1] = v[2];
            v[2] = coords[(i + 1) % N];
            mid[0].x = mid[1].x;
            mid[0].y = mid[1].y;
            mid[1].x = (v[1].x + v[2].x) / 2.0;
            mid[1].y = (v[1].y + v[2].y) / 2.0;
            vdist[0] = vdist[1];
            vdist[1] = v[1].distance(v[2]);
            double p = vdist[0] / (vdist[0] + vdist[1]);
            anchor.x = mid[0].x + p * (mid[1].x - mid[0].x);
            anchor.y = mid[0].y + p * (mid[1].y - mid[0].y);
            double xdelta = anchor.x - v[1].x;
            double ydelta = anchor.y - v[1].y;
            ctrl[i][0] = new Coordinate(alpha * (v[1].x - mid[0].x + xdelta) + mid[0].x - xdelta, alpha * (v[1].y - mid[0].y + ydelta) + mid[0].y - ydelta);
            ctrl[i][1] = new Coordinate(alpha * (v[1].x - mid[1].x + xdelta) + mid[1].x - xdelta, alpha * (v[1].y - mid[1].y + ydelta) + mid[1].y - ydelta);
        }
        return ctrl;
    }

    public Polygon smooth(Polygon p, double alpha) {
        Coordinate[] coords = p.getExteriorRing().getCoordinates();
        int N = coords.length - 1;
        Coordinate[][] controlPoints = this.getControlPoints(coords, N, alpha);
        ArrayList<Coordinate> smoothCoords = new ArrayList<Coordinate>();
        for (int i = 0; i < N; ++i) {
            int next = (i + 1) % N;
            double dist = coords[i].distance(coords[next]);
            if (dist < this.control.getMinLength()) {
                smoothCoords.add(new Coordinate(coords[i]));
                continue;
            }
            int smoothN = this.control.getNumVertices(dist);
            Coordinate[] segment = this.cubicBezier(coords[i], coords[next], controlPoints[i][1], controlPoints[next][0], smoothN);
            int copyN = i < N - 1 ? segment.length - 1 : segment.length;
            for (int k = 0; k < copyN; ++k) {
                smoothCoords.add(segment[k]);
            }
        }
        LinearRing shell = this.geomFactory.createLinearRing(smoothCoords.toArray(new Coordinate[0]));
        return this.geomFactory.createPolygon(shell, null);
    }
}

