/*
 * Decompiled with CFR 0.152.
 */
package jaitools.numeric;

import jaitools.CollectionFactory;
import jaitools.numeric.AbstractProcessor;
import jaitools.numeric.Statistic;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactMedianProcessor
extends AbstractProcessor {
    private static final Set<Statistic> SUPPORTED = Collections.singleton(Statistic.MEDIAN);
    private List<Double> values = CollectionFactory.list();
    private boolean calculationRequired = true;
    private double median;

    @Override
    public Collection<Statistic> getSupported() {
        return Collections.unmodifiableCollection(SUPPORTED);
    }

    @Override
    public final void offer(Double sample) {
        ++this.numOffered;
        if (this.getNumAccepted() >= Integer.MAX_VALUE && this.getNumOffered() == Integer.MAX_VALUE) {
            Logger.getLogger("jaitools.numeric").log(Level.WARNING, "Too many values for exact median calculation");
        }
        if (this.update(sample)) {
            ++this.numAccepted;
        }
    }

    @Override
    protected boolean update(Double sample) {
        if (this.isAccepted(sample)) {
            this.values.add(sample);
            this.calculationRequired = true;
            return true;
        }
        return false;
    }

    @Override
    public Double get(Statistic stat) {
        if (SUPPORTED.contains((Object)stat)) {
            if (this.getNumAccepted() == 0L) {
                return Double.NaN;
            }
            if (this.calculationRequired) {
                Collections.sort(this.values);
                int n0 = (int)this.getNumAccepted() / 2;
                this.median = this.getNumAccepted() % 2L == 1L ? this.values.get(n0) : (this.values.get(n0) + this.values.get(n0 - 1)) / 2.0;
                this.calculationRequired = false;
            }
            return this.median;
        }
        throw new IllegalArgumentException((Object)((Object)stat) + " not supported by " + this.getClass().getName());
    }
}

