/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geoserver.rest.format.StreamDataFormat;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.restlet.data.MediaType;

public class MapXMLFormat
extends StreamDataFormat {
    String myRootName;

    public MapXMLFormat() {
        this("root");
    }

    public MapXMLFormat(String s) {
        super(MediaType.APPLICATION_XML);
        this.myRootName = s;
    }

    protected void write(Object object, OutputStream out) throws IOException {
        Element root = new Element(this.myRootName);
        Document doc = new Document(root);
        this.insert(root, object);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        outputter.output(doc, out);
    }

    private final void insert(Element elem, Object o) {
        if (o instanceof Map) {
            for (Map.Entry entry : ((Map)o).entrySet()) {
                Element newElem = new Element(entry.getKey().toString());
                this.insert(newElem, entry.getValue());
                elem.addContent((Content)newElem);
            }
        } else if (o instanceof Collection) {
            Iterator it = ((Collection)o).iterator();
            while (it.hasNext()) {
                Element newElem = new Element("entry");
                Object entry = it.next();
                this.insert(newElem, entry);
                elem.addContent((Content)newElem);
            }
        } else {
            elem.addContent(o == null ? "" : o.toString());
        }
    }

    protected Object read(InputStream in) throws IOException {
        Document doc;
        Object result = null;
        SAXBuilder builder = new SAXBuilder();
        try {
            doc = builder.build(in);
        }
        catch (JDOMException e) {
            throw (IOException)new IOException("Error building document").initCause(e);
        }
        Element elem = doc.getRootElement();
        result = this.convert(elem);
        return result;
    }

    private Object convert(Element elem) {
        List children = elem.getChildren();
        if (children.size() == 0) {
            if (elem.getContent().size() == 0) {
                return null;
            }
            return elem.getText();
        }
        if (children.get(0) instanceof Element) {
            Element child = (Element)children.get(0);
            if (child.getName().equals("entry")) {
                ArrayList<Object> l = new ArrayList<Object>();
                for (Element curr : elem.getChildren("entry")) {
                    l.add(this.convert(curr));
                }
                return l;
            }
            HashMap<String, Object> m = new HashMap<String, Object>();
            for (Element curr : children) {
                m.put(curr.getName(), this.convert(curr));
            }
            return m;
        }
        throw new RuntimeException("Unable to parse XML");
    }
}

