CREATE CACHED TABLE "Entidade"
(
"Id" INTEGER IDENTITY,
"Nome" VARCHAR,
"Endereco" VARCHAR,
"Telefone" VARCHAR,
"Contato" VARCHAR,
"Email" VARCHAR,
"EhDeSistema" BOOLEAN,
"Descricao" VARCHAR,
"Cod_Identificacao" VARCHAR,
PRIMARY KEY ("Id")
);

CREATE CACHED TABLE "Bem"
(
"Id" INTEGER IDENTITY,
"Nome" VARCHAR,
"Descricao" VARCHAR,
"ValorCompra" DOUBLE,
"ValorAtual" DOUBLE,
"ValorVenda" DOUBLE,
"DataCompra" DATE,
"DataVenda" DATE,
"IndiceAnualDeDepreciacao" DOUBLE,
"LocalCompra" INTEGER,
PRIMARY KEY ("Id"),
FOREIGN KEY ("LocalCompra") REFERENCES "Entidade" ("Id")
);

CREATE CACHED TABLE "TipoLancamento"
(
"Id" INTEGER IDENTITY,
"Nome" VARCHAR,
"Descricao" VARCHAR,
"SuperTipo" INTEGER,
"EhDeSistema" BOOLEAN,
"RealizarPrevisao" BOOLEAN,
"Meta" DOUBLE,
PRIMARY KEY ("Id")
);

CREATE CACHED TABLE "Banco"
(
"Id" INTEGER IDENTITY,
"Nome" VARCHAR,
"Codigo" VARCHAR,
"EhDeSistema" BOOLEAN,
"Descricao" VARCHAR,
PRIMARY KEY ("Id")
);

CREATE CACHED TABLE "ContaCorrente" 
(
"Id" INTEGER IDENTITY,
"TipoConta" VARCHAR,
"NumeroConta" VARCHAR,
"NumeroAgencia" VARCHAR,
"DataAbertura" DATE,
"DataFechamento" DATE,
"Banco" INTEGER,
"SaldoInicial" DOUBLE,
"EhDeSistema" BOOLEAN,
"Descricao" VARCHAR,
FOREIGN KEY ("Banco") REFERENCES "Banco" ("Id")
);

CREATE CACHED TABLE "Aplicacao" 
(
"Id" INTEGER IDENTITY,
"TipoConta" VARCHAR,
"NumeroConta" VARCHAR,
"NumeroAgencia" VARCHAR,
"DataAbertura" DATE,
"DataFechamento" DATE,
"Banco" INTEGER,
"SaldoInicial" DOUBLE,
"Descricao" VARCHAR,
"TipoRendimento" INTEGER,
"ResgateAutomatico" BIT,
"ValorMinimoMovimentacao" DOUBLE,
"EhDeSistema" BOOLEAN,
FOREIGN KEY ("Banco") REFERENCES "Banco" ("Id")
);

CREATE CACHED TABLE "PrevisaoRendimento" 
(
"Id" INTEGER,
"TipoConta" VARCHAR,
"DataRendimento" DATE,
"ValorRendimento" DOUBLE,
PRIMARY KEY ("Id", "TipoConta", "DataRendimento"),
FOREIGN KEY ("Id") REFERENCES "Aplicacao" ("Id")
);

CREATE CACHED TABLE "Lancamento" 
(
"Id" INTEGER IDENTITY,
"Dia" DATE,
"Valor" DOUBLE,
"Tipo" INTEGER,
"Conta" INTEGER,
"TipoConta" VARCHAR,
"Produto" INTEGER,
"EntidadeEnvolvida" INTEGER,
"IntervaloRepeticao" INTEGER,
"TipoIntervaloRepeticao" INTEGER,
"Descricao" VARCHAR,
"EhDeSistema" BOOLEAN,
"EhPrevisao" BOOLEAN,
"Transferencia" DOUBLE,
"ContaTransf" INTEGER,
"TipoContaTransf" VARCHAR,
PRIMARY KEY ("Id"),
FOREIGN KEY ("Tipo") REFERENCES "TipoLancamento" ("Id"),
FOREIGN KEY ("Produto") REFERENCES "Bem" ("Id"),
FOREIGN KEY ("EntidadeEnvolvida") REFERENCES "Entidade" ("Id")
);

CREATE INDEX "Transferencia" ON "Lancamento"("Transferencia");
CREATE INDEX "DiaLancamento" ON "Lancamento"("Dia");
CREATE INDEX "Conta" ON "Lancamento"("TipoConta", "Conta");


CREATE CACHED TABLE "ComprasSupermercado" 
(
"Id" INTEGER IDENTITY,
"IdProduto" INTEGER,
"LocalCompra" INTEGER,
"DataCompra" DATE,
"ValorProduto" DOUBLE,
PRIMARY KEY ("Id"),
FOREIGN KEY ("IdProduto") REFERENCES "Bem" ("Id"),
FOREIGN KEY ("LocalCompra") REFERENCES "Entidade" ("Id")
);

CREATE CACHED TABLE "Usuario" 
(
"Id" INTEGER IDENTITY,
"Nome" VARCHAR,
"Senha" VARCHAR,
"Descricao" VARCHAR
);

CREATE CACHED TABLE "Acesso" 
(
"Id" INTEGER IDENTITY,
"Nome" VARCHAR,
"SuperTipo" INTEGER
);

CREATE CACHED TABLE "AcessoDoUsuario" 
(
"Id" INTEGER IDENTITY,
"IdAcesso" INTEGER,
"IdUsuario" INTEGER,
"TemAcesso" BOOLEAN,
PRIMARY KEY ("Id"),
FOREIGN KEY ("IdAcesso") REFERENCES "Acesso" ("Id"),
FOREIGN KEY ("IdUsuario") REFERENCES "Usuario" ("Id")
);

CREATE CACHED TABLE "TipoDeConta"
(
"Id" INTEGER IDENTITY,
"Nome" VARCHAR,
PRIMARY KEY ("Id")
);

CREATE CACHED TABLE "Propriedades"
(
"Id" INTEGER IDENTITY,
"Categoria" VARCHAR,
"Propriedades" OBJECT,
PRIMARY KEY ("Id")
);

CREATE CACHED TABLE "CartaoCredito"
(
"Id" INTEGER IDENTITY,
"TipoConta" VARCHAR,
"Operadora" INTEGER,
"TemBanco" BOOLEAN,
"Banco" INTEGER,
"NumeroCartao" VARCHAR,
"DataAbertura" DATE,
"DataFechamento" DATE,
"Limite" DOUBLE,
"LimiteExtra" DOUBLE,
"DataValidade" DATE,
"DiasParaPagamento" INTEGER,
"DataPagamento" INTEGER,
"JurosRotativo" DOUBLE,
"JurosFinanciamento" DOUBLE,
"TemPlanoDeFidelidade" BOOLEAN,
"QuantoValeCadaPonto" DOUBLE,
"ContaDebito" INTEGER,
"EhDeSistema" BOOLEAN,
"Descricao" VARCHAR,
FOREIGN KEY ("Operadora") REFERENCES "Entidade" ("Id")
);

CREATE CACHED TABLE "Plugin"
(
"Id" INTEGER IDENTITY,
"Nome" VARCHAR,
"Versao" DOUBLE,
"VersaoDB" INTEGER,
"InstallDir" VARCHAR,
"Descricao" VARCHAR
);