# grepGui.tcl

#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl
source gnoclMegaWidgets.tcl

set APP(NAME) grepGUI
set APP(VERSION) 0.1

set description "Default search..."
set switches "-i -n"
set searchPattern gnocl
set filePath [pwd]
set fontSize 10
set fontFamily MonoSpace

source grepGuiMenus.tcl

#---------------
#
#---------------
proc newSearch {w {title Unitled} } {
	$w addPage [tabContent] "%__$title"
}

#---------------
#
#---------------
proc textViewer {fileName lineNo} {
	# create window

	if { [info exists ::textViewerWindow] } {
		$::textViewerWindow iconify 0
		$::textViewerWindow configure -title $fileName
	} else {
		set txt [gnocl::text]
		set box [gnocl::box]
		set ::textViewerWindow [gnocl::window \
			-child $box \
			-widthRequest 300 \
			-heightRequest 500 \
			-title $fileName \
			-onDelete { unset ::textViewerWindow} \
			]
		$box add $txt -fill {1 1} -expand 1
	}

	$txt erase start end
	set fp [open $fileName "r"]
	$txt insert end [read $fp]
	close $fp

	gnocl::update


	# implement new commands
	# 	gnocl::info parent <widgetid>
	#	gnocl::info topLevel <widgetid>

	$txt setCursor [list $lineNo 0]
	$txt scrollToPosition cursor -align center
	$txt configure -hasFocus 1

}


#---------------
#
#---------------
proc doPreview { widget file } {
   set preview [$widget cget -previewWidget]
   if { [catch {$preview configure -visible 1 -image %/$file} erg] } {
      $preview configure -visible 0
   }
   $widget configure -previewWidgetActive 1
}

#---------------
#
#---------------
proc zoomText {widget state direction fontFamily fontSize} {

	if {$state == "1"} {
		switch $direction {
			up { incr fontSize }
			down { if {$fontSize != "8"} { incr fontSize -1 } }
			default { break }
		}
		$widget configure -baseFont [list $fontFamily $fontSize]
	}
	return $fontSize
}


#---------------
#
#---------------
proc tabContent { {w  empty} } {

 # box to contain all elements
 set box [gnocl::box -orientation vertical -padding 0]

 # table to create form
 set table [gnocl::table -homogeneous 0 -rowSpacing 0 -borderWidth 0]

 # row 1 widgets
 set lab1 [gnocl::label -text "Description" -widthChars 15 -align left]
 set ent1 [gnocl::entry -variable description -widthChars 80]
 set but1 [gnocl::button -icon "%#Save" -widthRequest 50 -tooltip "Save Search Description" -onClicked doSearch]

 # row 2 widgets
 set lab2 [gnocl::label -text "Search Pattern" -widthChars 15 -align left]
 set ent2 [gnocl::comboEntry \
 	-widthChars 80 \
	-variable searchPattern \
	-onKeyPress {puts HIDiHI } \
	-onKeyRelease { if {[ string match -nocase "Return" %K ] } { doSearch } }  \
	]
 set but2 [gnocl::button \
 	-icon "%#Help" \
	-widthRequest 50 \
	-tooltip "Give information on range of grep search patterns" \
	-onClicked {
		$::text erase start end
		set fp [open "patternHelp.txt" "r"]
		$::text insert end [read $fp ]
		close $fp
		} ]

 # row 3 widgets, grep switches
 set lab3 [gnocl::label -text "Switches" -widthChars 15 -align left]
 set ent3 [gnocl::comboEntry -widthChars 80 -variable switches]
 set but3 [gnocl::button \
 	-icon "%#Help" \
	-widthRequest 50 \
	-tooltip "Give information on range of grep switches" \
	-onClicked {
		$::text erase start end
		catch { eval exec "grep >/tmp/outfile --help"}
		set fp [open "/tmp/outfile"]
		$::text insert end [read $fp]
		close $fp
		} ]

 # row 4 widgets
 set lab4 [gnocl::label -text "Sources" -widthChars 15 -align left]
 set ent4 [gnocl::comboEntry -widthChars 80 -variable filePath]
 set but4 [gnocl::button \
 	-icon "%#Open" \
	-widthRequest 50 \
	-tooltip "Save Search Settings" \
	-onClicked {
		set filePath [gnocl::fileChooser \
			-action openFolder \
			-title "Please Choose a Source Directory.." ]
		puts "File = $filePath" }
	]

 $table addRow [list $lab1 "" $ent1 "" $but1 ] -fill {1 0} -expand {1 0}
 $table addRow [list $lab2 "" $ent2 "" $but2 ] -fill {1 0} -expand {1 0}
 $table addRow [list $lab3 "" $ent3 "" $but3 ] -fill {1 0} -expand {1 0}
 $table addRow [list $lab4 "" $ent4 "" $but4 ] -fill {1 0} -expand {1 0}

 $box add $table -fill {1 1} -expand 0

 set table2 [gnocl::table -homogeneous 0 -rowSpacing 0 -borderWidth 0]
 set lab5 [gnocl::label -text "Include Files" -widthChars 16 -align left]
 set ent5 [gnocl::comboEntry -widthChars 80 -variable includeFiles]
 set lab6 [gnocl::label -text "    Exclude Files" -widthChars 18 -align left]
 set ent6 [gnocl::comboEntry -widthChars 80 -variable excludeFiles]

 $table2 addRow [list $lab5 "" $ent5 "" $lab6 "" $ent6 ] -fill {1 0} -expand {0 0}

 $box add $table2 -fill {1 1} -expand 0


 set ::text [gnocl::text \
 	-baseColor #ffffdd \
	-editable 0 \
	-onScroll { set fontSize [zoomText %w %s %d $fontFamily $fontSize] } \
	-baseFont [list $::fontFamily $::fontSize] ]

set ::tree [gnocl::tree \
    -ruleHint 1 \
    -treeLines 1 \
	-onButtonPress {puts HIDIHI} \
	-onSelectionChanged {
		for {set i 0} {$i < [llength %p] } {incr i} {

			# split the referance
			foreach "a b" [lindex %p 0] {}

			# get file and entry details
			set content [%w get [lindex %p 0] $i]
			set file  [%w get $a 0]

			# parse the line, get the line number
			set mark [string first : $content]

			# adjust mark
			incr mark -1
			set line [string range $content  0 $mark]

			# adjust line, display the file
			textViewer $file [incr line -1]

			}
		} \
	-types {string} \
	-titles {"Search Results"} \
	-headersClickable 0 \
	-baseColor #FFFFDD \
	-baseFont {Mono 9}]
$::tree add {} {Mammal}
$::tree add 0 {Cat}
$::tree add 0 {Dog}


foreach row {Parrots Predator Fish Crustacia Molluscs Reptile Birds} {
	$::tree add {} $row

}
if {1} {
	$::tree add 1 {{Cockatoo} {Amazone}}
	$::tree add 2 {{Hawk} {Eagle}}
	$::tree expand -path "1" -recursive 1

}


# set ${::text}_taglist ""

# $box add $::text -fill {1 1} -expand 1
$box add $::tree -fill {1 1} -expand 1

 if {1} {
	 return $box
 } else {
 	return $table1
 }

}
#---------------
# perform the actual search, tree based
#---------------
proc doSearch {} {
	set home [pwd]
	cd $::filePath

	#clear the tree
	$::tree erase 0 end

	# build up the tree
	foreach item [glob *] {
		set ref [$::tree add {} $item]
		set cmd  "$::switches \"$::searchPattern\" $item"
		catch { eval exec "grep >/tmp/outfile $cmd"}
		set fp [open "/tmp/outfile"]
			# foreach line, add a row
			while { [gets $fp data] >= 0 } {
				# Process data.
				# ... insert your code here...
				eval "$::tree add $ref \{\{ \{$data \} \}\}"
				puts $data
			}
		}

}

#---------------
# perform the actual search, text based
#---------------
proc _doSearch {} {
	#eval exec "grep >outfile --help"
	set home [pwd]
	cd $::filePath

	$::text erase start end
	# remove existing tag
	foreach tag [set ${::text}_taglist] {
		$::text tag remove start end -tags $tag

		set cmd  "$::switches \"$::searchPattern\" $item"
		$::statusBar push "grep $cmd"
		catch { eval exec "grep >/tmp/outfile $cmd"}
		set fp [open "/tmp/outfile"]
			# foreach line, add a row
		close $fp
	}

	foreach item [glob *] {
		# create a custom tag for the fileName
		$::text tag create "Tag_$item" \
			-foreground black \
			-onEvent {
				puts "t = %t b = %b [string compare %t "button2Press"]"
				if { [string compare %t "button2Press"] == 0 && [string compare %b "1" ] == 0} {
					puts "event tag name = %n event type = %t"
					%w tag configure %n -foreground blue
					} else {
						%w tag configure %n -foreground black
					}
				}
		lappend ${::text}_taglist "Tag_$item"
		set cmd  "$::switches \"$::searchPattern\" $item"
		$::statusBar push "grep $cmd"
		catch { eval exec "grep >/tmp/outfile $cmd"}
		set fp [open "/tmp/outfile"]
		$::text insert end "[string repeat - 80]\n"
		$::text insert end "Results from $item\n"
		$::text insert end "[string repeat - 80]\n\n"
		$::text insert end "[read $fp]\n" -tags "Tag_$item"
		close $fp
	}

		# gnocl code not working too well, keep internal list
		catch { puts "dump = [$::text dump text]" }
		puts "taglist = [set ${::text}_taglist]"

	cd $home

	$::text tag create SEARCH -background  yellow
	$::text search gnocl -tags SEARCH

}

# create main window container, then add elements
set box [gnocl::box -orientation vertical -borderWidth 0 -spacing 0]
$box add [gnocl::menuBar -children [list $file $help]]
$box add $toolBar
set notebook [gnocl::notebook]
$box add [list $notebook] -fill {1 1} -expand 1
set statusBar [gnocl::statusBar]
$box add $statusBar

# create a first document
newSearch $notebook

set mainWin [gnocl::window -title "$APP(NAME) <$APP(VERSION)>" -resizable 1 -child $box -widthRequest 800 -heightRequest 600]



gnocl::mainLoop
