/*! \page page3 Virtual Terminal Emulation
  \section sec Gnome Virtual Terminal Emulation Widget.
  Implementation of the Gnome Virtual Terminal Emulation Widget.
  \subsection subsection1 An example section

  http://library.gnome.org/devel/vte/unstable/VteTerminal.html
*/

#include "gnoclVTE.h"

/**
 * \brief   Implement gnocl::vte widget.
 * \param   Tcl_Interp *interp  Pointer to client visible fields of interpreter structure.
 */
int Gnoclvte_Init ( Tcl_Interp *interp )
{

	printf ( "Initializing gnocl virtual terminal emulator version %s\n", VERSION );

	if ( Tcl_InitStubs ( interp, "8.3", 0 ) == NULL )
		return TCL_ERROR;

	if ( Tcl_PkgRequire ( interp, "Gnocl", VERSION, 0 ) == NULL )
		return TCL_ERROR;

	if ( Tcl_PkgProvide ( interp, "GnoclVTE", VERSION ) != TCL_OK )
		return TCL_ERROR;

	/* gnoclSourceViewCmd is located in sourceview.c */
	Tcl_CreateObjCommand ( interp, "gnocl::vte", gnoclVTECmd, NULL, NULL );

	return TCL_OK;
}

