#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl

# namespace to contain pseudo-static variables
set lastLine ""

proc insertCursor {w  l} {

	if {[$w getCursor] != $l } {
   		set l [$w getCursor]
   		set a [lindex $l 0]
   		$w tag remove "0 0" end -tags {cursor}
#		set lineEnd "$a [$w getLineLength $l]"
#		$w tag apply "$a 0" $lineEnd -tags {cursor}
#   	$w tag apply cursor sentenceStart -tags cursor
#		$w tag apply cursor sentenceEnd -tags cursor
# Because keywords positions are determined from the widget iterator and not arguments,
# some more fanciful uses of the keywords can be used.
		$w tag apply sentenceStart sentenceEnd -tags cursor

   } else {
   		set l 0
   }

   # return last position of the cursor
   return $l
}

set box [gnocl::box -orientation vertical]

set text [gnocl::text]
set but1 [gnocl::button -text "Dump" \
   -onClicked { puts >>>>[$text dump {0 0} {end}]  } ]

$box add $text -fill {1 1} -expand 1
$box add $but1

$text configure -onButtonRelease {
   set lastLine [insertCursor %w $lastLine]
   }

$text configure -onKeyRelease {
   set lastLine [insertCursor %w $lastLine]
   }

$text tag create blue -foreground blue
$text tag create cursor -underline single -foreground red
for {set i 0 } {$i <= 10} {incr i} {
	$text insert end "This is "
	$text insert end "Gnocl" -tags blue
	$text insert end "!\n"
}
gnocl::window -title "Text" -child $box

# gnocl::mainLoop
