
 #!/bin/sh
 # the next line restarts using tclsh \
 exec tclsh "$0" "$@"

 package require Gnocl

set toolBar [gnocl::toolBar -style text]
$toolBar add item -text "Q"
$toolBar add item -text "UL"
$toolBar add item -text "JL"
$toolBar add item -text "JR"


gnocl::window -title "ToolBar" -child $toolBar



set list [gnocl::list \
	-onClicked {puts "%w"} \
	-titles {"bool" "string" "integer" "float"} \
	-types {boolean string integer float} \
	-children {{1 "box" 345 4.546} {0 "text" 123 5.79}}]
$list add {{0 "list" -104 1.45} {1 "window" 3350 9.58}}
$list columnConfigure 2 -onCellData "setColor %v"
proc setColor { val } {
   if { $val < 0 } {
      return "-foreground red"
   }
   return "-foreground blue"
}
gnocl::window -title "List" -child $list -defaultWidth 250 -defaultHeight 120
