#---------------
# gnoclTextUndoRedo.tcl
#---------------
# Created by WIlliam J Giddings
# 03/08/2008
#---------------
# Description:
# Provide undo/redo functionality for the gnocl text widget.
#---------------
# Notes:
#
#---------------

# use arrays to create stacks to contain details of the events
# this is more effecient than using lists
# see Welch, Jones & Hobbs pp101

proc push {stack value} {
	upvar $stack S
	if { ! [info exists S(top)] } {
		set S(top) 0
	}
	set S($S(top)) $value
	incr S(top)
}

proc pop { stack } {
	upvar $stack S
	if { ![info exists S(top)] } {
		return {}
	}
	if {$S(top) == 0 } {
		return {}
	} else {
		incr S(top) -1
		set x $S($S(top))
		unset S($S(top))
		return $x
	}
}

#
# UNDO / REDO proceedures
#

# Notes:
# -----
# Create undo/redo buffers unique to the widget.
proc on_undo { w } {

	global ${w}.UNDO
	global ${w}.REDO

	if { [array size ${w}.UNDO] == 0 } {
		return
	}
	set action [pop ${w}.UNDO]

	switch [lindex $action 0 ] {
		"insert-text"
			{
				# determine the end of range to delete from length of text inserted
				set col [expr [lindex [lindex $action 1] 1]  +[lindex $action 3] ]
				set row [lindex [lindex $action 1] 0]
				$w erase [lindex $action 1] [list $row $col]

				# resposition the cursor
				$w setCursor [list $row $col]
			}
		"delete-range"
			{
				# strip leading and trailing braces from the string
				$w insert [lindex $action 1] [string trim [lindex $action 3] \{\}]

				# resposition the cursor to the end of the inserted text
				$w setCursor  [lindex $action 1]
				$w setCursor cursor+[string length [lindex $action 2]]
			}
	}
	# display the changes
	$w scrollToPosition cursor
	$w configure -hasFocus 1
	push ${w}.REDO $action
}

proc on_redo { w } {

	global ${w}.UNDO
	global ${w}.REDO

	if { [array size ${w}.REDO] == 0 } {
		return
	}
	set action [pop ${w}.REDO]
	switch [lindex $action 0 ] {
		"insert-text"
			{

				# determine the end of range to delete from length of text inserted
				# The text is returned as a list, so if there is purely whitespace this
				# will re mis-read as a sub-list by the interpreter.
				# So, get the text as the first item to prevent this.
				$w insert [lindex $action 1] [lindex [lindex $action 2] 0]

			    # resposition the cursor to the end of the inserted text
				$w setCursor  [lindex $action 1]
				$w setCursor cursor+[string length [lindex $action 2]]
			}
		"delete-range"
			{

				# determine the end of range to delete from length of text inserted
				set col [expr [lindex [lindex $action 1] 1]  +[lindex $action 3] ]
				set row [lindex [lindex $action 1] 0]
				$w erase [lindex $action 1] [list $row $col]

				# resposition the cursor
				$w setCursor [list $row $col]
			}
	}

	# display the changes
	$w scrollToPosition cursor
	$w configure -hasFocus 1
	push ${w}.UNDO $action

}
