/* newWidgetTemplate.c */

#include "gnocl.h"
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <assert.h>

static GnoclOption widgetOptions[] =
{
	{ "-switch1", GNOCL_OBJ, NULL },        /* 0 */
	{ "-switch2", GNOCL_OBJ, NULL },        /* 1 */
};

static int configure ( Tcl_Interp *interp, GtkWidget *widget, GnoclOption options[] )
{
	return TCL_OK;
}

static int cget ( Tcl_Interp *interp, GtkWidget *widget, GnoclOption options[], int idx )
{
	return TCL_OK;
}

/* configure/hand widget commands */
static int widgetFunc ( ClientData data, Tcl_Interp *interp, int objc, Tcl_Obj * const objv[] )
{
	return TCL_OK;
}

/* other funcs imported from demo */


/* Redraw all of the points when an expose-event occurs. If you do not do this, the drawing area will be cleared. */
static gboolean expose_event ( GtkWidget *area, GdkEventExpose *event, GPtrArray *parray )
{
	guint i, x, y;
	GdkPoint points[5];

	/* Loop through the coordinates, redrawing them onto the drawing area. */

	for ( i = 0; i < parray->len; i = i + 2 )
	{
		x = GPOINTER_TO_INT ( parray->pdata[i] );
		y = GPOINTER_TO_INT ( parray->pdata[i+1] );

		points[0].x = x;   points[0].y = y;
		points[1].x = x + 1; points[1].y = y;
		points[2].x = x - 1; points[2].y = y;
		points[3].x = x;   points[3].y = y + 1;
		points[4].x = x;   points[4].y = y - 1;

		gdk_draw_points ( area->window, area->style->fg_gc[GTK_WIDGET_STATE ( area ) ], points, 5 );
	}

	return TRUE;
}

/* Draw a point where the user pressed the mouse and points on each of the four sides of that point. */
static gboolean button_pressed ( GtkWidget *area, GdkEventButton *event, GPtrArray *parray )
{
	gint x = event->x, y = event->y;
	GdkPoint points[5] = { {x, y}, {x + 1, y}, {x - 1, y}, {x, y + 1}, {x, y - 1} };

	gdk_draw_points ( area->window, area->style->fg_gc[GTK_WIDGET_STATE ( area ) ], points, 5 );

	g_ptr_array_add ( parray, GINT_TO_POINTER ( x ) );
	g_ptr_array_add ( parray, GINT_TO_POINTER ( y ) );

	return FALSE;
}

/* Draw a point where the moved the mouse pointer while a button was
 * pressed along with points on each of the four sides of that point. */
static gboolean motion_notify ( GtkWidget *area, GdkEventMotion *event, GPtrArray *parray )
{
	gint x = event->x, y = event->y;
	GdkPoint points[5] = { {x, y}, {x + 1, y}, {x - 1, y}, {x, y + 1}, {x, y - 1} };

	gdk_draw_points ( area->window, area->style->fg_gc[GTK_WIDGET_STATE ( area ) ], points, 5 );

	g_ptr_array_add ( parray, GINT_TO_POINTER ( x ) );
	g_ptr_array_add ( parray, GINT_TO_POINTER ( y ) );

	return FALSE;
}

/* Clear the drawing area when the user presses the Delete key. */
static gboolean key_pressed ( GtkWidget *area, GdkEventKey *event, GPtrArray *parray )
{
	if ( event->keyval == GDK_Delete )
	{
		gdk_window_clear ( area->window );
		g_ptr_array_remove_range ( parray, 0, parray->len );
	}

	return FALSE;
}

/* function called to create widget */
int gnoclDrawingAreaCmd ( ClientData data, Tcl_Interp *interp, int objc, Tcl_Obj * const objv[] )
{
	int       ret;
	GtkWidget *widget;
	GPtrArray *parray;

	/* create and show the wudget */
	parray = g_ptr_array_sized_new ( 5000 );
	widget = gtk_drawing_area_new ();
	gtk_widget_show ( GTK_WIDGET ( widget ) );

	GTK_WIDGET_SET_FLAGS ( widget, GTK_CAN_FOCUS );
	gtk_widget_add_events ( widget, GDK_BUTTON_PRESS_MASK | GDK_BUTTON_MOTION_MASK | GDK_KEY_PRESS_MASK );

	g_signal_connect ( G_OBJECT ( widget ), "button_press_event", G_CALLBACK ( button_pressed ), parray );
	g_signal_connect ( G_OBJECT ( widget ), "motion_notify_event", G_CALLBACK ( motion_notify ), parray );
	g_signal_connect ( G_OBJECT ( widget ), "key_press_event", G_CALLBACK ( key_pressed ), parray );
	g_signal_connect ( G_OBJECT ( widget ), "expose_event", G_CALLBACK ( expose_event ), parray );

	gtk_widget_show ( GTK_WIDGET ( widget ) );

	/* You must do this after the widget is visible because it must first
	 * * be realized for the GdkWindow to be valid! */
	gdk_window_set_cursor ( widget->window, gdk_cursor_new ( GDK_PENCIL ) );

	/* register the new widget for use with the Tcl interpretor */
	return gnoclRegisterWidget ( interp, GTK_WIDGET ( widget ), NULL );

}

