# directoryTree.tcl
#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

package require Gnocl

gnocl::resourceFile .gtkrc

#puts [info vars]

#puts [array names env]

#puts $env(HOME)

set directory $env(HOME)

set tree [gnocl::tree \
    -treeLinePattern --- \
    -expanders 1 \
    -types {string integer} \
    -titles {"Name" "Size"} \
    -ruleHint 0]

$tree configure -ruleHint 1 -treeLines 1

set i 1
set colour white
foreach item [glob -directory $directory -tails -type d * ] {
    puts >>$item

    set id [$tree add {} "$item" ]
    puts "id = $id"
    # $tree cellConfigure "$i 0" -background $colour
    # $tree cellConfigure "$i " -background $colour
    # $tree cellConfigure "$i 2" -background $colour

    incr i
    if {$colour == "white" } {
        set colour "grey"
    } else {
        set colour "white"}
}

foreach item [glob -directory $directory -tails -type f * ] {
    puts ~~$item
}


if {1} {
    $tree add {} {Mamals Birds Bugs}
    $tree add 0 {{Cat 4} {Dog 4} {Human 2}}
    foreach {paro pred} [$tree add 1 {Parrots Predator}] break
    $tree add $paro {{Cockatoo 2} {Amazone 2}}
    $tree add $pred {{Hawk 2} {Eagle 2}}
}

$tree expand -path "1" -recursive 1
gnocl::window -title "Tree" -child $tree -defaultWidth 300 -defaultHeight 200


